/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.profile;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import org.jcvi.jillion.core.residue.nt.Nucleotide;

public enum DisplayCountStrategy {
    COUNTS{

        @Override
        void write(PrintWriter writer, Nucleotide mostFreq, double gap, double a, double c, double g, double t) throws IOException {
            writer.printf("%s\t%s\t%s\t%s\t%s\t%s%n", mostFreq, DECIMAL_FORMAT.format(gap), DECIMAL_FORMAT.format(a), DECIMAL_FORMAT.format(c), DECIMAL_FORMAT.format(g), DECIMAL_FORMAT.format(t));
        }
    }
    ,
    PERCENTAGES{

        @Override
        void write(PrintWriter writer, Nucleotide mostFreq, double gap, double a, double c, double g, double t) throws IOException {
            double total = gap + a + c + g + t;
            if (total == 0.0) {
                writer.printf("%s\t0\t0\t0\t0\t0%n", mostFreq);
            } else {
                writer.printf("%s\t%.0f\t%.0f\t%.0f\t%.0f\t%.0f%n", mostFreq, gap / total * 100.0, 100.0 * a / total, 100.0 * c / total, 100.0 * g / total, 100.0 * t / total);
            }
        }
    };

    private static final DecimalFormat DECIMAL_FORMAT;

    abstract void write(PrintWriter var1, Nucleotide var2, double var3, double var5, double var7, double var9, double var11) throws IOException;

    static {
        DECIMAL_FORMAT = new DecimalFormat("0.##");
    }
}

