/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.profile;

import org.jcvi.jillion.core.residue.nt.Nucleotide;

final class BaseCount
implements Comparable<BaseCount> {
    private final Nucleotide base;
    private final double count;

    public BaseCount(Nucleotide base, double count) {
        this.base = base;
        this.count = count;
    }

    Nucleotide getBase() {
        return this.base;
    }

    public double getCount() {
        return this.count;
    }

    @Override
    public int compareTo(BaseCount o) {
        return Double.compare(o.count, this.count);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        long temp = Double.doubleToLongBits(this.count);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseCount)) {
            return false;
        }
        BaseCount other = (BaseCount)obj;
        if (this.base != other.base) {
            return false;
        }
        return Double.doubleToLongBits(this.count) == Double.doubleToLongBits(other.count);
    }
}

