/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.orf;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.Frame;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.Codon;
import org.jcvi.jillion.core.residue.aa.IupacTranslationTables;
import org.jcvi.jillion.core.residue.aa.ProteinSequenceBuilder;
import org.jcvi.jillion.core.residue.aa.TranslationTable;
import org.jcvi.jillion.core.residue.aa.TranslationVisitor;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.orf.Orf;

public class OrfFinder {
    public List<Orf> find(NucleotideSequence seq) {
        return this.find(seq, IupacTranslationTables.STANDARD, FinderOptions.SEARCH_FORWARD, FinderOptions.SEARCH_REVERSE);
    }

    public List<Orf> find(NucleotideSequence seq, TranslationTable translationTable, FinderOptions ... finderOptions) {
        ArrayList<Orf> orfs = new ArrayList<Orf>();
        EnumSet<FinderOptions> options = EnumSet.noneOf(FinderOptions.class);
        for (FinderOptions o : finderOptions) {
            options.add(o);
        }
        if (options.contains((Object)FinderOptions.SEARCH_FORWARD)) {
            for (Frame f : Frame.forwardFrames()) {
                OrfVisitor visitor = new OrfVisitor(f);
                translationTable.translate(seq, f, visitor);
                visitor.getOrf().ifPresent(orf -> orfs.add((Orf)orf));
            }
        }
        if (options.contains((Object)FinderOptions.SEARCH_REVERSE)) {
            NucleotideSequence reverseSeq = seq.toBuilder().reverseComplement().build();
            for (Frame f : Frame.reverseFrames()) {
                OrfVisitor visitor = new OrfVisitor(f);
                translationTable.translate(reverseSeq, f.getOppositeFrame(), visitor);
                visitor.getOrf().ifPresent(orf -> orfs.add((Orf)orf));
            }
        }
        return orfs;
    }

    private static class OrfVisitor
    implements TranslationVisitor {
        ProteinSequenceBuilder builder = new ProteinSequenceBuilder();
        Frame frame;
        long startCoord = -1L;
        long stopCoord = -1L;
        boolean hasStart = false;
        boolean hasStop = false;
        Orf orf = null;

        public OrfVisitor(Frame frame) {
            this.frame = frame;
        }

        @Override
        public void visitCodon(long nucleotideCoordinate, Codon codon) {
            this.builder.append(codon.getAminoAcid());
        }

        @Override
        public TranslationVisitor.FoundStartResult foundStart(long nucleotideCoordinate, Codon codon) {
            if (this.hasStart) {
                this.builder.append(codon.getAminoAcid());
            } else {
                this.hasStart = true;
                this.startCoord = nucleotideCoordinate;
                this.builder.append(AminoAcid.Methionine);
            }
            return TranslationVisitor.FoundStartResult.CONTINUE;
        }

        @Override
        public TranslationVisitor.FoundStopResult foundStop(long nucleotideCoordinate, Codon codon) {
            this.hasStop = true;
            this.stopCoord = nucleotideCoordinate += 2L;
            this.builder.append(codon.getAminoAcid());
            return TranslationVisitor.FoundStopResult.STOP;
        }

        @Override
        public void end() {
            if (this.hasStart && this.hasStop) {
                this.orf = new Orf(this.frame, this.builder.build(), Range.of(this.startCoord, this.stopCoord));
            }
        }

        public Optional<Orf> getOrf() {
            return Optional.ofNullable(this.orf);
        }
    }

    public static enum FinderOptions {
        SEARCH_FORWARD,
        SEARCH_REVERSE;

    }
}

