/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.maq.bfq;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqWriter;

public class BfqFileWriterBuilder {
    private final File outputBfqFile;
    private ByteOrder endian = ByteOrder.nativeOrder();

    public BfqFileWriterBuilder(File outputBfqFile) {
        if (outputBfqFile == null) {
            throw new NullPointerException("output bfq file can not be null");
        }
        this.outputBfqFile = outputBfqFile;
    }

    public BfqFileWriterBuilder endian(ByteOrder endian) {
        if (endian == null) {
            throw new NullPointerException("endian can not be null");
        }
        this.endian = endian;
        return this;
    }

    public FastqWriter build() throws IOException {
        IOUtil.mkdirs(this.outputBfqFile.getParentFile());
        return new BinaryFastqFileWriter(this.outputBfqFile, this.endian);
    }

    private static class BinaryFastqFileWriter
    implements FastqWriter {
        private final OutputStream out;
        private final ByteOrder byteOrder;

        public BinaryFastqFileWriter(File bqf, ByteOrder endian) throws IOException {
            this.byteOrder = endian;
            this.out = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(bqf)));
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void write(FastqRecord record) throws IOException {
            this.write(record.getId(), record.getNucleotideSequence(), record.getQualitySequence());
        }

        @Override
        public void write(String id, NucleotideSequence sequence, QualitySequence qualities, String optionalComment) throws IOException {
            this.write(id, sequence, qualities);
        }

        @Override
        public void write(String id, NucleotideSequence nucleotides, QualitySequence qualities) throws IOException {
            int nameLength = id.length() + 1;
            int numBases = (int)nucleotides.getLength();
            int bufferSize = 8 + nameLength + numBases;
            ByteBuffer buf = ByteBuffer.allocate(bufferSize);
            buf.order(this.byteOrder);
            buf.putInt(nameLength);
            buf.put(this.asNullTerminatedBytes(id, nameLength));
            buf.putInt(numBases);
            buf.put(this.encodeBasesAndQualities(nucleotides, qualities, numBases));
            buf.flip();
            byte[] b = new byte[bufferSize];
            buf.get(b);
            this.out.write(b);
        }

        private byte[] encodeBasesAndQualities(NucleotideSequence nucleotides, QualitySequence qualities, int numBases) {
            Iterator basesIter = nucleotides.iterator();
            byte[] buffer = qualities.toArray();
            for (int i = 0; i < buffer.length; ++i) {
                Nucleotide n = (Nucleotide)basesIter.next();
                int v = this.encode(n);
                if (v > 3) {
                    buffer[i] = 0;
                    continue;
                }
                buffer[i] = (byte)Math.min(buffer[i], 63);
                int n2 = i;
                buffer[n2] = (byte)(buffer[n2] | v << 6);
            }
            return buffer;
        }

        private int encode(Nucleotide n) {
            switch (n) {
                case Adenine: {
                    return 0;
                }
                case Cytosine: {
                    return 1;
                }
                case Guanine: {
                    return 2;
                }
                case Thymine: {
                    return 3;
                }
            }
            return 4;
        }

        private byte[] asNullTerminatedBytes(String id, int nameLength) {
            byte[] b = new byte[nameLength];
            char[] cs = id.toCharArray();
            for (int i = 0; i < cs.length; ++i) {
                b[i] = (byte)cs[i];
            }
            return b;
        }
    }
}

