/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.maq.bfq;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.internal.core.io.OpenAwareInputStream;
import org.jcvi.jillion.trace.fastq.FastqParser;
import org.jcvi.jillion.trace.fastq.FastqRecordVisitor;
import org.jcvi.jillion.trace.fastq.FastqVisitor;

public abstract class BfqFileParser
implements FastqParser {
    private final ByteOrder endian;

    public static FastqParser create(File bfqFile) throws IOException {
        return BfqFileParser.create(bfqFile, ByteOrder.nativeOrder());
    }

    public static FastqParser create(File bfqFile, ByteOrder endian) throws IOException {
        return new BfqFileBasedParser(bfqFile, endian);
    }

    public static FastqParser create(InputStream bfqFileStream) throws IOException {
        return BfqFileParser.create(bfqFileStream, ByteOrder.nativeOrder());
    }

    public static FastqParser create(InputStream bfqFileStream, ByteOrder endian) throws IOException {
        return new BfqInputStreamParser(bfqFileStream, endian);
    }

    private BfqFileParser(ByteOrder endian) throws IOException {
        if (endian == null) {
            throw new NullPointerException("endian can not be null");
        }
        this.endian = endian;
    }

    @Override
    public boolean canCreateMemento() {
        return true;
    }

    @Override
    public boolean isReadOnceOnly() {
        return false;
    }

    @Override
    public boolean canParse() {
        return true;
    }

    @Override
    public void parse(FastqVisitor visitor) throws IOException {
        if (visitor == null) {
            throw new NullPointerException("visitor can not be null");
        }
        OpenAwareInputStream in = null;
        try {
            in = this.createInputStream();
            this.parseBqfData(visitor, in, 0L);
        }
        finally {
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }
    }

    private void parseBqfData(FastqVisitor visitor, OpenAwareInputStream in, long offset) throws IOException {
        FastqRecordVisitor recordVisitor = null;
        long currentOffset = offset;
        Callback callback = this.createCallback(currentOffset);
        while (in.isOpen() && callback.keepParsing()) {
            callback.updateCurrentOffset(currentOffset);
            int nameLength = IOUtil.readSignedInt(in, this.endian);
            String name = this.readNullTerminatedString(in, nameLength);
            int numBases = IOUtil.readSignedInt(in, this.endian);
            recordVisitor = visitor.visitDefline(callback, name, null);
            currentOffset += (long)(8 + numBases + nameLength);
            if (recordVisitor == null) {
                IOUtil.blockingSkip(in, numBases);
                continue;
            }
            byte[] basesAndQualities = IOUtil.readByteArray(in, numBases);
            StringBuilder basesBuilder = new StringBuilder(numBases);
            QualitySequenceBuilder qualitiesBuilder = new QualitySequenceBuilder(numBases).turnOffDataCompression(true);
            for (int i = 0; i < basesAndQualities.length; ++i) {
                byte value = basesAndQualities[i];
                if (value == 0) {
                    basesBuilder.append(Nucleotide.Unknown);
                    qualitiesBuilder.append(0);
                    continue;
                }
                int qv = value & 0x3F;
                int base = value >> 6 & 3;
                basesBuilder.append(BfqFileParser.getBaseFromInt(base));
                qualitiesBuilder.append(qv);
            }
            recordVisitor.visitNucleotides(basesBuilder.toString());
            if (callback.keepParsing()) {
                recordVisitor.visitQualities(qualitiesBuilder.build());
            }
            if (!callback.keepParsing()) continue;
            recordVisitor.visitEnd();
        }
        if (!callback.keepParsing()) {
            if (recordVisitor != null) {
                recordVisitor.halted();
            }
            visitor.halted();
        }
        visitor.visitEnd();
    }

    private static Nucleotide getBaseFromInt(int b) {
        switch (b) {
            case 0: {
                return Nucleotide.Adenine;
            }
            case 1: {
                return Nucleotide.Cytosine;
            }
            case 2: {
                return Nucleotide.Guanine;
            }
            case 3: {
                return Nucleotide.Thymine;
            }
        }
        throw new IllegalStateException("invalid byte value");
    }

    private String readNullTerminatedString(OpenAwareInputStream in, int nameLength) throws IOException {
        byte[] b = IOUtil.readByteArray(in, nameLength);
        return new String(b, 0, nameLength - 1, IOUtil.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(FastqVisitor visitor, FastqVisitor.FastqVisitorCallback.FastqVisitorMemento memento) throws IOException {
        if (visitor == null) {
            throw new NullPointerException("visitor can not be null");
        }
        if (memento == null) {
            throw new NullPointerException("memento can not be null");
        }
        if (!(memento instanceof BfqMemento)) {
            throw new IllegalArgumentException("invalid memento type, must be created by this class");
        }
        BfqMemento bfqMemento = (BfqMemento)memento;
        if (bfqMemento.parserInstance != this) {
            throw new IllegalArgumentException("invalid memento, must be created by this parser instance");
        }
        OpenAwareInputStream in = null;
        try {
            in = this.createInputStream();
            long startOffset = bfqMemento.startOffset;
            IOUtil.blockingSkip(in, startOffset);
            this.parseBqfData(visitor, in, startOffset);
        }
        finally {
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }
    }

    abstract OpenAwareInputStream createInputStream() throws IOException;

    abstract Callback createCallback(long var1);

    private final class NoMementoCallback
    extends Callback {
        private NoMementoCallback(long startOffset) {
            super(startOffset);
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        public FastqVisitor.FastqVisitorCallback.FastqVisitorMemento createMemento() {
            throw new UnsupportedOperationException("can not create mementos");
        }
    }

    private static class BfqInputStreamParser
    extends BfqFileParser {
        private final OpenAwareInputStream in;
        private boolean hasBeenReadBefore = false;

        private BfqInputStreamParser(InputStream in, ByteOrder endian) throws IOException {
            super(endian);
            this.in = new OpenAwareInputStream(in);
        }

        @Override
        protected synchronized OpenAwareInputStream createInputStream() throws IOException {
            if (!this.hasBeenReadBefore) {
                this.hasBeenReadBefore = true;
                return this.in;
            }
            throw new IOException("already read");
        }

        @Override
        public Optional<File> getFile() {
            return Optional.empty();
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        public boolean isReadOnceOnly() {
            return true;
        }

        @Override
        public void parse(FastqVisitor visitor, FastqVisitor.FastqVisitorCallback.FastqVisitorMemento memento) throws IOException {
            throw new UnsupportedOperationException("mementos not supported");
        }

        @Override
        protected Callback createCallback(long startOffset) {
            return new NoMementoCallback(startOffset);
        }
    }

    private static class BfqFileBasedParser
    extends BfqFileParser {
        private final File bfqFile;

        private BfqFileBasedParser(File bfqFile, ByteOrder endian) throws IOException {
            super(endian);
            this.bfqFile = bfqFile;
        }

        @Override
        protected OpenAwareInputStream createInputStream() throws IOException {
            return new OpenAwareInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(this.bfqFile))));
        }

        @Override
        protected Callback createCallback(long startOffset) {
            return new Callback(startOffset);
        }

        @Override
        public Optional<File> getFile() {
            return Optional.of(this.bfqFile);
        }
    }

    private static final class BfqMemento
    implements FastqVisitor.FastqVisitorCallback.FastqVisitorMemento {
        private final BfqFileParser parserInstance;
        private final long startOffset;

        public BfqMemento(BfqFileParser parserInstance, long startOffset) {
            this.parserInstance = parserInstance;
            this.startOffset = startOffset;
        }
    }

    private class Callback
    implements FastqVisitor.FastqVisitorCallback {
        private final AtomicBoolean keepParsing;
        private long currentOffset;

        private Callback(long startOffset) {
            this.currentOffset = startOffset;
            this.keepParsing = new AtomicBoolean(true);
        }

        @Override
        public boolean canCreateMemento() {
            return true;
        }

        @Override
        public FastqVisitor.FastqVisitorCallback.FastqVisitorMemento createMemento() {
            return new BfqMemento(BfqFileParser.this, this.currentOffset);
        }

        @Override
        public void haltParsing() {
            this.keepParsing.set(false);
        }

        public boolean keepParsing() {
            return this.keepParsing.get();
        }

        public void updateCurrentOffset(long offset) {
            this.currentOffset = offset;
        }
    }
}

