/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.maq.bfq;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.maq.bfq.BfqFileParser;
import org.jcvi.jillion.trace.fastq.FastqDataStore;
import org.jcvi.jillion.trace.fastq.FastqFileDataStoreBuilder;
import org.jcvi.jillion.trace.fastq.FastqParser;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;

public class BfqFileDataStoreBuilder {
    private static final FastqQualityCodec REQUIRED_DUMMY_VALUE = FastqQualityCodec.SANGER;
    private final FastqFileDataStoreBuilder delegate;

    public BfqFileDataStoreBuilder(File bfqFile) throws IOException {
        this(BfqFileParser.create(bfqFile));
    }

    public BfqFileDataStoreBuilder(InputStream in) throws IOException {
        this(BfqFileParser.create(in));
    }

    public BfqFileDataStoreBuilder(File bfqFile, ByteOrder endian) throws IOException {
        this(BfqFileParser.create(bfqFile, endian));
    }

    public BfqFileDataStoreBuilder(InputStream in, ByteOrder endian) throws IOException {
        this(BfqFileParser.create(in, endian));
    }

    private BfqFileDataStoreBuilder(FastqParser parser) throws IOException {
        this.delegate = new FastqFileDataStoreBuilder(parser);
        this.delegate.qualityCodec(REQUIRED_DUMMY_VALUE);
    }

    public BfqFileDataStoreBuilder filter(DataStoreFilter filter) {
        this.delegate.filter(filter);
        return this;
    }

    public BfqFileDataStoreBuilder hint(DataStoreProviderHint hint) {
        this.delegate.hint(hint);
        return this;
    }

    public FastqDataStore build() throws IOException {
        return this.delegate.build();
    }
}

