/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.maq.bfa;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Iterator;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.fasta.nt.NucleotideFastaWriter;

public class BfaWriterBuilder {
    private final File outputBfaFile;
    private final OutputStream out;
    private ByteOrder endian = ByteOrder.nativeOrder();

    public BfaWriterBuilder(File outputBfaFile) {
        if (outputBfaFile == null) {
            throw new NullPointerException("output bfa file can not be null");
        }
        this.out = null;
        this.outputBfaFile = outputBfaFile;
    }

    public BfaWriterBuilder(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("output bfq stream can not be null");
        }
        this.out = out;
        this.outputBfaFile = null;
    }

    public BfaWriterBuilder endian(ByteOrder endian) {
        if (endian == null) {
            throw new NullPointerException("endian can not be null");
        }
        this.endian = endian;
        return this;
    }

    public NucleotideFastaWriter build() throws IOException {
        if (this.outputBfaFile != null) {
            IOUtil.mkdirs(this.outputBfaFile.getParentFile());
            return new BinaryFastaFileWriter(new BufferedOutputStream(new FileOutputStream(this.outputBfaFile)), this.endian);
        }
        return new BinaryFastaFileWriter(this.out, this.endian);
    }

    private static class BinaryFastaFileWriter
    implements NucleotideFastaWriter {
        private final OutputStream out;
        private final ByteOrder byteOrder;

        public BinaryFastaFileWriter(OutputStream out, ByteOrder endian) throws IOException {
            this.byteOrder = endian;
            this.out = out;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void write(NucleotideFastaRecord record) throws IOException {
            this.write(record.getId(), (NucleotideSequence)record.getSequence());
        }

        @Override
        public void write(String id, NucleotideSequence sequence) throws IOException {
            int nameLength = id.length() + 1;
            int numBases = (int)sequence.getLength();
            int arrayLength = BinaryFastaFileWriter.numberOfElementsInEncodedArray(numBases);
            int bufferSize = 12 + nameLength + arrayLength * 16;
            ByteBuffer buf = ByteBuffer.allocate(bufferSize);
            buf.order(this.byteOrder);
            buf.putInt(nameLength);
            buf.put(this.asNullTerminatedBytes(id, nameLength));
            buf.putInt(numBases);
            buf.putInt(arrayLength);
            long[] encodedBases = new long[arrayLength];
            long[] mask = new long[arrayLength];
            Iterator iter = sequence.iterator();
            for (int i = 0; i < arrayLength - 1; ++i) {
                long v = 0L;
                long m = 0L;
                block13: for (int j = 0; j < 32; ++j) {
                    Nucleotide n = (Nucleotide)iter.next();
                    v <<= 2;
                    m <<= 2;
                    switch (n) {
                        case Adenine: {
                            m |= 3L;
                            continue block13;
                        }
                        case Cytosine: {
                            v |= 1L;
                            m |= 3L;
                            continue block13;
                        }
                        case Guanine: {
                            v |= 2L;
                            m |= 3L;
                            continue block13;
                        }
                        case Thymine: {
                            v |= 3L;
                            m |= 3L;
                            continue block13;
                        }
                    }
                }
                encodedBases[i] = v;
                mask[i] = m;
            }
            long v = 0L;
            long m = 0L;
            block14: for (int j = 0; j < 32; ++j) {
                v <<= 2;
                m <<= 2;
                if (!iter.hasNext()) continue;
                Nucleotide n = (Nucleotide)iter.next();
                switch (n) {
                    case Adenine: {
                        m |= 3L;
                        continue block14;
                    }
                    case Cytosine: {
                        v |= 1L;
                        m |= 3L;
                        continue block14;
                    }
                    case Guanine: {
                        v |= 2L;
                        m |= 3L;
                        continue block14;
                    }
                    case Thymine: {
                        v |= 3L;
                        m |= 3L;
                        continue block14;
                    }
                }
            }
            encodedBases[arrayLength - 1] = v;
            mask[arrayLength - 1] = m;
            LongBuffer longBuffer = buf.asLongBuffer();
            longBuffer.put(encodedBases);
            longBuffer.put(mask);
            buf.rewind();
            byte[] b = new byte[bufferSize];
            buf.get(b);
            this.out.write(b);
        }

        private static int numberOfElementsInEncodedArray(int numBases) {
            return numBases / 32 + (numBases % 32 == 0 ? 0 : 1);
        }

        @Override
        public void write(String id, NucleotideSequence sequence, String optionalComment) throws IOException {
            this.write(id, sequence);
        }

        private byte[] asNullTerminatedBytes(String id, int nameLength) {
            byte[] b = new byte[nameLength];
            char[] cs = id.toCharArray();
            for (int i = 0; i < cs.length; ++i) {
                b[i] = (byte)cs[i];
            }
            return b;
        }
    }
}

