/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.maq.bfa;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.FastaVisitor;
import org.jcvi.jillion.fasta.FastaVisitorCallback;
import org.jcvi.jillion.internal.core.io.OpenAwareInputStream;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;

public abstract class BfaParser
implements FastaParser {
    private final ByteOrder endian;

    public static FastaParser create(File bfaFile) throws IOException {
        return BfaParser.create(bfaFile, ByteOrder.nativeOrder());
    }

    public static FastaParser create(File bfaFile, ByteOrder endian) throws IOException {
        return new BfaFileParser(bfaFile, endian);
    }

    public static FastaParser create(InputStream bfaFileStream) {
        return BfaParser.create(bfaFileStream, ByteOrder.nativeOrder());
    }

    public static FastaParser create(InputStream bfaFileStream, ByteOrder endian) {
        return new BfaInputStreamParser(bfaFileStream, endian);
    }

    private BfaParser(ByteOrder endian) {
        if (endian == null) {
            throw new NullPointerException("endian can not be null");
        }
        this.endian = endian;
    }

    abstract OpenAwareInputStream createInputStream() throws IOException;

    final void parseBfaData(FastaVisitor visitor, OpenAwareInputStream in, long offset) throws IOException {
        FastaRecordVisitor recordVisitor = null;
        long currentOffset = offset;
        Callback callback = this.createCallback(currentOffset);
        while (in.isOpen() && callback.keepParsing()) {
            char base;
            long n;
            long m;
            int shiftAmount;
            int baseOffset;
            int j;
            long basesValue;
            long maskValue;
            callback.updateCurrentOffset(currentOffset);
            int nameLength = IOUtil.readSignedInt(in, this.endian);
            String name = this.readNullTerminatedString(in, nameLength);
            int numBases = IOUtil.readSignedInt(in, this.endian);
            int numCompactedLongs = IOUtil.readSignedInt(in, this.endian);
            recordVisitor = visitor.visitDefline(callback, name, null);
            currentOffset += (long)(12 + numCompactedLongs * 16 + nameLength);
            if (recordVisitor == null) {
                IOUtil.blockingSkip(in, numCompactedLongs * 16);
                continue;
            }
            long[] bases = IOUtil.readLongArray(in, numCompactedLongs, this.endian);
            long[] masks = IOUtil.readLongArray(in, numCompactedLongs, this.endian);
            StringBuilder basesBuilder = new StringBuilder(numBases);
            for (int i = 0; i < bases.length - 1; ++i) {
                maskValue = masks[i];
                basesValue = bases[i];
                for (j = 31; j >= 0 && (baseOffset = i << 5 | 31 - j) < numBases; --j) {
                    shiftAmount = j * 2;
                    m = maskValue >> shiftAmount & 3L;
                    n = basesValue >> shiftAmount & 3L;
                    base = m == 0L ? (char)'N' : (char)BfaParser.getBaseFromInt((int)n);
                    basesBuilder.append(base);
                }
            }
            int lastOffset = bases.length - 1;
            maskValue = masks[lastOffset];
            basesValue = bases[lastOffset];
            for (j = 31; j >= 0 && (baseOffset = lastOffset << 5 | 31 - j) < numBases; --j) {
                shiftAmount = j * 2;
                m = maskValue >> shiftAmount & 3L;
                n = basesValue >> shiftAmount & 3L;
                base = m == 0L ? (char)'N' : (char)BfaParser.getBaseFromInt((int)n);
                basesBuilder.append(base);
            }
            recordVisitor.visitBodyLine(basesBuilder.toString());
            if (!callback.keepParsing()) continue;
            recordVisitor.visitEnd();
        }
        if (!callback.keepParsing()) {
            if (recordVisitor != null) {
                recordVisitor.halted();
            }
            visitor.halted();
        }
        visitor.visitEnd();
    }

    protected abstract Callback createCallback(long var1);

    private static char getBaseFromInt(int b) {
        switch (b) {
            case 0: {
                return 'A';
            }
            case 1: {
                return 'C';
            }
            case 2: {
                return 'G';
            }
            case 3: {
                return 'T';
            }
        }
        throw new IllegalStateException("invalid byte value : " + b);
    }

    private String readNullTerminatedString(OpenAwareInputStream in, int nameLength) throws IOException {
        byte[] b = IOUtil.readByteArray(in, nameLength);
        return new String(b, 0, nameLength - 1, IOUtil.UTF_8);
    }

    @Override
    public void parse(FastaVisitor visitor) throws IOException {
        if (visitor == null) {
            throw new NullPointerException("visitor can not be null");
        }
        OpenAwareInputStream in = null;
        try {
            in = this.createInputStream();
            this.parseBfaData(visitor, in, 0L);
        }
        finally {
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }
    }

    private static final class BfaInputStreamParser
    extends BfaParser {
        private final OpenAwareInputStream inputStream;
        private boolean hasParsedBefore = false;

        public BfaInputStreamParser(InputStream inputStream, ByteOrder endian) {
            super(endian);
            this.inputStream = new OpenAwareInputStream(inputStream);
        }

        @Override
        public boolean isReadOnceOnly() {
            return true;
        }

        @Override
        public synchronized void parse(FastaVisitor visitor) throws IOException {
            super.parse(visitor);
        }

        @Override
        public void parse(FastaVisitor visitor, FastaVisitorCallback.FastaVisitorMemento memento) throws IOException {
            throw new UnsupportedOperationException("can not use mementos with inputstream");
        }

        @Override
        protected OpenAwareInputStream createInputStream() throws IOException {
            if (!this.hasParsedBefore) {
                return this.inputStream;
            }
            this.hasParsedBefore = true;
            if (this.canParse()) {
                return this.inputStream;
            }
            throw new IllegalStateException("can not accept visitor - inputstream is closed");
        }

        @Override
        public boolean canParse() {
            return this.inputStream.isOpen();
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        protected Callback createCallback(long currentOffset) {
            return new NotMementoedCallback();
        }
    }

    private static final class NotMementoedCallback
    implements Callback {
        private final AtomicBoolean keepParsing = new AtomicBoolean(true);

        private NotMementoedCallback() {
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        public FastaVisitorCallback.FastaVisitorMemento createMemento() {
            throw new UnsupportedOperationException("mementos not supported");
        }

        @Override
        public void haltParsing() {
            this.keepParsing.set(false);
        }

        @Override
        public boolean keepParsing() {
            return this.keepParsing.get();
        }

        @Override
        public void updateCurrentOffset(long offset) {
        }
    }

    private static final class BfaFileParser
    extends BfaParser {
        private final File bfaFile;

        protected BfaFileParser(File bfaFile, ByteOrder endian) throws IOException {
            super(endian);
            if (!bfaFile.exists()) {
                throw new FileNotFoundException(bfaFile.getAbsolutePath());
            }
            this.bfaFile = bfaFile;
        }

        @Override
        public boolean canCreateMemento() {
            return true;
        }

        @Override
        public boolean canParse() {
            return true;
        }

        @Override
        protected Callback createCallback(long currentOffset) {
            return new MementoedCallback(currentOffset);
        }

        @Override
        public boolean isReadOnceOnly() {
            return false;
        }

        @Override
        protected OpenAwareInputStream createInputStream() throws IOException {
            return new OpenAwareInputStream(new BufferedInputStream(new FileInputStream(this.bfaFile)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(FastaVisitor visitor, FastaVisitorCallback.FastaVisitorMemento memento) throws IOException {
            if (visitor == null) {
                throw new NullPointerException("visitor can not be null");
            }
            if (memento == null) {
                throw new NullPointerException("memento can not be null");
            }
            if (!(memento instanceof BfaMemento)) {
                throw new IllegalArgumentException("invalid memento type, must be created by this class");
            }
            BfaMemento bfaMemento = (BfaMemento)memento;
            if (bfaMemento.parserInstance != this) {
                throw new IllegalArgumentException("invalid memento, must be created by this parser instance");
            }
            long startOffset = bfaMemento.startOffset;
            OpenAwareInputStream in = null;
            try {
                in = new OpenAwareInputStream(new BufferedInputStream(new RandomAccessFileInputStream(this.bfaFile, startOffset)));
                this.parseBfaData(visitor, in, startOffset);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(in);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }

        private final class MementoedCallback
        implements Callback {
            private final AtomicBoolean keepParsing;
            private long currentOffset;

            private MementoedCallback() {
                this(0L);
            }

            private MementoedCallback(long startOffset) {
                this.currentOffset = startOffset;
                this.keepParsing = new AtomicBoolean(true);
            }

            @Override
            public boolean canCreateMemento() {
                return true;
            }

            @Override
            public FastaVisitorCallback.FastaVisitorMemento createMemento() {
                return new BfaMemento(BfaFileParser.this, this.currentOffset);
            }

            @Override
            public void haltParsing() {
                this.keepParsing.set(false);
            }

            @Override
            public boolean keepParsing() {
                return this.keepParsing.get();
            }

            @Override
            public void updateCurrentOffset(long offset) {
                this.currentOffset = offset;
            }
        }
    }

    private static interface Callback
    extends FastaVisitorCallback {
        public boolean keepParsing();

        public void updateCurrentOffset(long var1);
    }

    private static final class BfaMemento
    implements FastaVisitorCallback.FastaVisitorMemento {
        private final BfaParser parserInstance;
        private final long startOffset;

        public BfaMemento(BfaParser parserInstance, long startOffset) {
            this.parserInstance = parserInstance;
            this.startOffset = startOffset;
        }
    }
}

