/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.fastq;

import java.util.Arrays;
import java.util.DoubleSummaryStatistics;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalDouble;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;

class ParsedQualitySequence
implements QualitySequence {
    private final FastqQualityCodec codec;
    private final String encodedQualities;
    private DoubleSummaryStatistics stats;
    private int hash;

    ParsedQualitySequence(FastqQualityCodec codec, String encodedQualities) {
        this.codec = codec;
        this.encodedQualities = encodedQualities;
    }

    @Override
    public PhredQuality get(long offset) {
        return this.codec.decode(this.encodedQualities.charAt((int)offset));
    }

    @Override
    public long getLength() {
        return this.encodedQualities.length();
    }

    @Override
    public Iterator<PhredQuality> iterator(Range range) {
        return new QualitySequenceBuilder(this.toArray(range)).iterator();
    }

    @Override
    public QualitySequenceBuilder toBuilder() {
        return new QualitySequenceBuilder(this.toArray());
    }

    @Override
    public Iterator<PhredQuality> iterator() {
        return this.toBuilder().iterator();
    }

    @Override
    public byte[] toArray() {
        char[] chars = this.encodedQualities.toCharArray();
        byte[] ret = new byte[chars.length];
        int offset = this.codec.getOffset();
        for (int i = 0; i < chars.length; ++i) {
            ret[i] = (byte)(chars[i] - offset);
        }
        return ret;
    }

    @Override
    public byte[] toArray(Range range) {
        int shift;
        char[] chars = this.encodedQualities.toCharArray();
        byte[] ret = new byte[chars.length];
        int offset = this.codec.getOffset();
        int end = (int)range.getEnd();
        for (int i = shift = (int)range.getBegin(); i <= end; ++i) {
            ret[i - shift] = (byte)(chars[i] - offset);
        }
        return ret;
    }

    private void computeSummaryStatsIfNeeded() {
        if (this.stats != null) {
            return;
        }
        if (this.encodedQualities.isEmpty()) {
            this.stats = new DoubleSummaryStatistics();
            return;
        }
        DoubleSummaryStatistics stats2 = new DoubleSummaryStatistics();
        char[] chars = this.encodedQualities.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            stats2.accept(chars[i]);
        }
        this.stats = stats2;
    }

    @Override
    public OptionalDouble getAvgQuality() throws ArithmeticException {
        this.computeSummaryStatsIfNeeded();
        if (this.stats.getCount() == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.stats.getAverage() - (double)this.codec.getOffset());
    }

    @Override
    public Optional<PhredQuality> getMinQuality() {
        this.computeSummaryStatsIfNeeded();
        double value = this.stats.getMin();
        if (Double.POSITIVE_INFINITY == value) {
            return Optional.empty();
        }
        return Optional.of(this.codec.decode((char)value));
    }

    @Override
    public Optional<PhredQuality> getMaxQuality() {
        this.computeSummaryStatsIfNeeded();
        double value = this.stats.getMax();
        if (Double.NEGATIVE_INFINITY == value) {
            return Optional.empty();
        }
        return Optional.of(this.codec.decode((char)value));
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 && this.getLength() > 0L) {
            this.hash = Arrays.hashCode(this.toArray());
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ParsedQualitySequence) {
            ParsedQualitySequence other = (ParsedQualitySequence)obj;
            if (this.codec == other.codec) {
                return this.encodedQualities.equals(other.encodedQualities);
            }
        }
        if (obj instanceof QualitySequence) {
            return Arrays.equals(this.toArray(), ((QualitySequence)obj).toArray());
        }
        return false;
    }
}

