/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.fastq;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.internal.trace.fastq.CommentedParsedFastqRecord;
import org.jcvi.jillion.internal.trace.fastq.ParsedQualitySequence;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqRecordBuilder;

public class ParsedFastqRecord
implements FastqRecord {
    private final String id;
    private final String encodedQualities;
    private final FastqQualityCodec qualityCodec;
    private final String nucleotideSequenceString;
    private NucleotideSequence nucleotideSequence;
    private QualitySequence qualitySequence;
    private final boolean turnOffCompression;

    public ParsedFastqRecord(String id, String nucleotideSequence, String encodedQualities, FastqQualityCodec qualityCodec, boolean turnOffCompression) {
        this.id = id;
        this.nucleotideSequenceString = nucleotideSequence;
        this.encodedQualities = encodedQualities;
        this.qualityCodec = qualityCodec;
        this.turnOffCompression = turnOffCompression;
    }

    @Override
    public long getLength() {
        return this.nucleotideSequenceString.length();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public NucleotideSequence getNucleotideSequence() {
        if (this.nucleotideSequence == null) {
            this.nucleotideSequence = new NucleotideSequenceBuilder(this.nucleotideSequenceString).turnOffDataCompression(this.turnOffCompression).build();
        }
        return this.nucleotideSequence;
    }

    @Override
    public QualitySequence getQualitySequence() {
        if (this.qualitySequence == null) {
            this.qualitySequence = new ParsedQualitySequence(this.qualityCodec, this.encodedQualities);
        }
        return this.qualitySequence;
    }

    @Override
    public String getComment() {
        return null;
    }

    public String getEncodedQualities() {
        return this.encodedQualities;
    }

    public FastqQualityCodec getQualityCodec() {
        return this.qualityCodec;
    }

    @Override
    public FastqRecordBuilder toBuilder() {
        return new ParsedFastqRecordBuilder(this);
    }

    @Override
    public OptionalDouble getAvgQuality() throws ArithmeticException {
        long total = 0L;
        char[] chars = this.encodedQualities.toCharArray();
        if (chars.length == 0) {
            return OptionalDouble.empty();
        }
        for (int i = 0; i < chars.length; ++i) {
            total += (long)chars[i];
        }
        double avg = total / (long)chars.length;
        return OptionalDouble.of(avg - (double)this.qualityCodec.getOffset());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.getNucleotideSequence().hashCode();
        result = 31 * result + this.getQualitySequence().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FastqRecord)) {
            return false;
        }
        FastqRecord other = (FastqRecord)obj;
        if (!this.id.equals(other.getId())) {
            return false;
        }
        if (!this.getNucleotideSequence().equals(other.getNucleotideSequence())) {
            return false;
        }
        return this.getQualitySequence().equals(other.getQualitySequence());
    }

    public String getNucleotideString() {
        return this.nucleotideSequenceString;
    }

    public String toString() {
        return "UncommentedFastqRecord [id=" + this.id + ", nucleotides=" + this.nucleotideSequenceString + ", qualities=" + this.getQualitySequence() + "]";
    }

    private static final class ParsedFastqRecordBuilder
    implements FastqRecordBuilder {
        private String id;
        private String encodedQualities;
        private final FastqQualityCodec qualityCodec;
        private String nucleotideSequenceString;
        private final boolean turnOffCompression;
        private String comment;
        private boolean lengthsModified = false;

        public ParsedFastqRecordBuilder(FastqRecord record) {
            ParsedFastqRecord r = (ParsedFastqRecord)record;
            this.id = r.id;
            this.encodedQualities = r.encodedQualities;
            this.qualityCodec = r.qualityCodec;
            this.nucleotideSequenceString = r.nucleotideSequenceString;
            this.turnOffCompression = r.turnOffCompression;
            this.comment = r.getComment();
        }

        @Override
        public FastqRecordBuilder comment(String comments) {
            this.comment = comments;
            return this;
        }

        @Override
        public FastqRecord build() {
            if (this.lengthsModified) {
                this.assertValidLength();
            }
            if (this.comment == null) {
                return new ParsedFastqRecord(this.id, this.nucleotideSequenceString, this.encodedQualities, this.qualityCodec, this.turnOffCompression);
            }
            return new CommentedParsedFastqRecord(this.id, this.nucleotideSequenceString, this.encodedQualities, this.qualityCodec, this.turnOffCompression, this.comment);
        }

        @Override
        public Optional<String> comment() {
            return Optional.ofNullable(this.comment);
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public FastqRecordBuilder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @Override
        public NucleotideSequence basecalls() {
            return new NucleotideSequenceBuilder(this.nucleotideSequenceString).build();
        }

        @Override
        public FastqRecordBuilder basecalls(NucleotideSequence basecalls) {
            this.nucleotideSequenceString = basecalls.toString();
            this.lengthsModified = true;
            return this;
        }

        @Override
        public QualitySequence qualities() {
            return this.qualityCodec.decode(this.encodedQualities);
        }

        @Override
        public FastqRecordBuilder qualities(QualitySequence qualities) {
            this.encodedQualities = this.qualityCodec.encode(qualities);
            this.lengthsModified = true;
            return this;
        }

        @Override
        public FastqRecordBuilder trim(Range trimRange) {
            this.encodedQualities = this.encodedQualities.substring((int)trimRange.getBegin(), (int)trimRange.getEnd() + 1);
            this.nucleotideSequenceString = this.nucleotideSequenceString.substring((int)trimRange.getBegin(), (int)trimRange.getEnd() + 1);
            this.lengthsModified = true;
            return this;
        }

        private void assertValidLength() {
            long qualityLength;
            long basecallLength = this.nucleotideSequenceString.length();
            if (basecallLength != (qualityLength = (long)this.encodedQualities.length())) {
                throw new IllegalArgumentException(String.format("basecalls and qualities must have the same length! %d vs %d", basecallLength, qualityLength));
            }
        }
    }
}

