/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.ztr.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.core.seq.trace.sanger.chromat.ztr.data.Data;
import org.jcvi.jillion.internal.trace.chromat.ztr.ZTRUtil;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.DataHeader;

public enum ZLibData implements Data
{
    INSTANCE;


    @Override
    public byte[] parseData(byte[] data) throws IOException {
        Inflater decompresser = null;
        try {
            ByteBuffer size = ByteBuffer.allocate(4);
            size.put(data, 1, 4);
            int uncompressedLength = (int)ZTRUtil.readInt(IOUtil.switchEndian(size.array()));
            ByteBuffer compressedData = ByteBuffer.allocate(data.length - 5);
            compressedData.put(data, 5, data.length - 5);
            decompresser = new Inflater();
            decompresser.setInput(compressedData.array());
            ByteBuffer byteBuffer = ByteBuffer.allocate(uncompressedLength);
            decompresser.inflate(byteBuffer.array());
            byte[] byArray = byteBuffer.array();
            return byArray;
        }
        catch (DataFormatException dfEx) {
            throw new IOException("could not parse ZLibData", dfEx);
        }
        finally {
            if (decompresser != null) {
                decompresser.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encodeData(byte[] data) throws IOException {
        Deflater zlibCompresser = new Deflater();
        try {
            zlibCompresser.setInput(data);
            zlibCompresser.finish();
            byte[] compressedData = new byte[data.length * 2];
            int numberOfCompressedBytes = zlibCompresser.deflate(compressedData);
            ByteBuffer encodedBuffer = ByteBuffer.allocate(numberOfCompressedBytes + 5);
            encodedBuffer.put(DataHeader.ZLIB_ENCODED);
            byte[] size = IOUtil.switchEndian(IOUtil.convertUnsignedIntToByteArray(data.length));
            encodedBuffer.put(size);
            encodedBuffer.put(compressedData, 0, numberOfCompressedBytes);
            encodedBuffer.flip();
            byte[] byArray = Arrays.copyOfRange(encodedBuffer.array(), 0, encodedBuffer.limit());
            return byArray;
        }
        finally {
            zlibCompresser.end();
        }
    }

    @Override
    public byte[] encodeData(byte[] data, byte ignored) throws IOException {
        return this.encodeData(data);
    }
}

