/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.ztr.data;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jcvi.jillion.internal.core.io.ValueSizeStrategy;
import org.jcvi.jillion.internal.core.seq.trace.sanger.chromat.ztr.data.Data;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.DataHeader;

public enum ShrinkToEightBitData implements Data
{
    SHORT_TO_BYTE(ValueSizeStrategy.SHORT, 2, DataHeader.SHRINK_SHORT_TO_BYTE_ENCODED),
    INTEGER_TO_BYTE(ValueSizeStrategy.INTEGER, 4, DataHeader.SHRINK_INTEGER_TO_BYTE_ENCODED);

    private static final byte GUARD = -128;
    private final ValueSizeStrategy valueSizeStrategy;
    private final byte formatByte;
    private final int numberOfBytesPerElement;

    private ShrinkToEightBitData(ValueSizeStrategy valueSizeStrategy, int numberOfBytesPerElement, byte formatByte) {
        this.valueSizeStrategy = valueSizeStrategy;
        this.formatByte = formatByte;
        this.numberOfBytesPerElement = numberOfBytesPerElement;
    }

    private boolean isGuard(byte value) {
        return value == -128;
    }

    private ByteBuffer getInput(byte[] data) {
        ByteBuffer in = ByteBuffer.allocate(data.length - 1);
        in.put(data, 1, data.length - 1);
        in.flip();
        return in;
    }

    protected byte[] toByteArray(ByteBuffer out) {
        out.flip();
        int size = out.remaining();
        ByteBuffer result = ByteBuffer.allocate(size);
        result.put(out);
        return result.array();
    }

    @Override
    public byte[] parseData(byte[] data) {
        ByteBuffer in = this.getInput(data);
        ByteBuffer result = ByteBuffer.allocate(this.getMaxPossibleDecodedSize(data.length - 1));
        while (in.hasRemaining()) {
            byte value = in.get();
            if (this.isGuard(value)) {
                this.valueSizeStrategy.put(result, this.valueSizeStrategy.getNext(in));
                continue;
            }
            this.valueSizeStrategy.put(result, value);
        }
        return this.toByteArray(result);
    }

    protected int getMaxPossibleDecodedSize(int numberOfEncodedBytes) {
        return numberOfEncodedBytes * this.numberOfBytesPerElement;
    }

    @Override
    public byte[] encodeData(byte[] data) throws IOException {
        ByteBuffer encodedBuffer = ByteBuffer.allocate(4 * data.length);
        encodedBuffer.put(this.formatByte);
        ByteBuffer inputBuffer = ByteBuffer.wrap(data);
        while (inputBuffer.hasRemaining()) {
            byte[] next = this.getNext(inputBuffer);
            int nextAsInt = new BigInteger(next).intValue();
            if (nextAsInt <= 127 && nextAsInt >= -127) {
                encodedBuffer.put((byte)nextAsInt);
                continue;
            }
            encodedBuffer.put((byte)-128);
            encodedBuffer.put(next);
        }
        encodedBuffer.flip();
        return Arrays.copyOfRange(encodedBuffer.array(), 0, encodedBuffer.limit());
    }

    protected byte[] getNext(ByteBuffer inputBuffer) {
        byte[] array = new byte[this.numberOfBytesPerElement];
        inputBuffer.get(array);
        return array;
    }

    @Override
    public byte[] encodeData(byte[] data, byte ignored) throws IOException {
        return this.encodeData(data);
    }
}

