/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.ztr.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.core.seq.trace.sanger.chromat.ztr.data.Data;
import org.jcvi.jillion.internal.core.util.RunLength;
import org.jcvi.jillion.internal.trace.chromat.ztr.ZTRUtil;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.DataHeader;

public enum RunLengthEncodedData implements Data
{
    INSTANCE;

    private static final byte GUARD_ESCAPE = 0;
    private static final int MIN_RUN_LENGTH = 4;
    private static final int MAX_RUN_LENGTH = 255;
    public static final byte DEFAULT_GUARD = -106;

    @Override
    public byte[] parseData(byte[] data) throws IOException {
        int uncompressedLength = this.computeUncompressedLength(data);
        ByteBuffer in = ByteBuffer.wrap(data);
        in.position(5);
        byte guard = in.get();
        ByteBuffer out = ByteBuffer.allocate(uncompressedLength);
        this.parse(in, guard, out);
        return out.array();
    }

    private void parse(ByteBuffer in, byte guard, ByteBuffer out) {
        List<RunLength<Byte>> runLengthList = this.parseIntoRunLength(in, guard);
        this.write(runLengthList, out);
    }

    private List<RunLength<Byte>> parseIntoRunLength(ByteBuffer in, byte guard) {
        ArrayList<RunLength<Byte>> runLengthList = new ArrayList<RunLength<Byte>>();
        while (in.hasRemaining()) {
            byte value = in.get();
            if (value == guard) {
                int count = this.getCount(in);
                if (count == 0) {
                    runLengthList.add(new RunLength<Byte>(guard, 1));
                    continue;
                }
                byte repValue = in.get();
                runLengthList.add(new RunLength<Byte>(repValue, count));
                continue;
            }
            runLengthList.add(new RunLength<Byte>(value, 1));
        }
        return runLengthList;
    }

    private void write(List<RunLength<Byte>> runLengthList, ByteBuffer out) {
        for (RunLength<Byte> runLength : runLengthList) {
            this.putConsecutiveValues(out, runLength.getLength(), runLength.getValue());
        }
    }

    private void putConsecutiveValues(ByteBuffer out, int count, byte repValue) {
        byte[] consecutiveValues = new byte[count];
        Arrays.fill(consecutiveValues, repValue);
        out.put(consecutiveValues);
    }

    private int computeUncompressedLength(byte[] data) {
        byte[] uncompressedLengthArray = new byte[4];
        for (int i = 1; i < 5; ++i) {
            uncompressedLengthArray[4 - i] = data[i];
        }
        return (int)ZTRUtil.readInt(uncompressedLengthArray);
    }

    private int getCount(ByteBuffer in) {
        return IOUtil.toUnsignedByte(in.get());
    }

    @Override
    public byte[] encodeData(byte[] data) throws IOException {
        return this.encodeData(data, (byte)-106);
    }

    @Override
    public byte[] encodeData(byte[] data, byte guard) throws IOException {
        ByteBuffer encodedBuffer = ByteBuffer.allocate(2 * data.length + 6);
        encodedBuffer.put(DataHeader.RUN_LENGTH_ENCODED);
        ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
        lengthBuffer.putInt(data.length);
        encodedBuffer.put(IOUtil.switchEndian(lengthBuffer.array()));
        encodedBuffer.put(guard);
        this.runLengthEncode(data, guard, encodedBuffer);
        encodedBuffer.flip();
        return Arrays.copyOfRange(encodedBuffer.array(), 0, encodedBuffer.limit());
    }

    private void runLengthEncode(byte[] dataToEncode, byte guard, ByteBuffer out) {
        int runLength;
        for (int i = 0; i < dataToEncode.length; i += runLength) {
            runLength = this.getNextRunLength(dataToEncode, i);
            if (this.runLengthIsTooSmall(runLength)) {
                this.encodeUnrunLenghEncodedBlock(dataToEncode, guard, out, i, runLength);
                continue;
            }
            this.encodeRunLengthEncodedBlock(dataToEncode, guard, out, i, runLength);
        }
    }

    private void encodeRunLengthEncodedBlock(byte[] dataToEncode, byte guard, ByteBuffer out, int i, int runLength) {
        out.put(guard);
        out.put((byte)runLength);
        out.put(dataToEncode[i]);
    }

    private void encodeUnrunLenghEncodedBlock(byte[] dataToEncode, byte guard, ByteBuffer out, int i, int runLength) {
        for (int j = 0; j < runLength; ++j) {
            byte nextByte = dataToEncode[i + j];
            if (nextByte == guard) {
                out.put(guard);
                out.put((byte)0);
                continue;
            }
            out.put(nextByte);
        }
    }

    private boolean runLengthIsTooSmall(int runLength) {
        return runLength < 4;
    }

    private int getNextRunLength(byte[] dataToEncode, int currentOffset) {
        int k;
        for (k = currentOffset; k < dataToEncode.length && dataToEncode[currentOffset] == dataToEncode[k] && k - currentOffset != 255; ++k) {
        }
        return k - currentOffset;
    }
}

