/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.ztr.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.core.seq.trace.sanger.chromat.ztr.data.Data;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.DataHeader;

public enum FollowData implements Data
{
    INSTANCE;

    private static int DATA_START_POSITION;

    @Override
    public byte[] parseData(byte[] data) throws IOException {
        int uncompressedLength = data.length - DATA_START_POSITION;
        byte[] follow = this.createFollowArray(data);
        ByteBuffer compressedData = this.getCompressedData(data, uncompressedLength);
        ByteBuffer uncompressedData = ByteBuffer.allocate(uncompressedLength);
        int prev = IOUtil.toUnsignedByte(compressedData.get());
        uncompressedData.put((byte)prev);
        while (compressedData.hasRemaining()) {
            prev = IOUtil.toUnsignedByte((byte)(follow[prev] - compressedData.get()));
            uncompressedData.put((byte)prev);
        }
        return uncompressedData.array();
    }

    private ByteBuffer getCompressedData(byte[] data, int uncompressedLength) {
        ByteBuffer compressedData = ByteBuffer.allocate(uncompressedLength);
        compressedData.put(data, DATA_START_POSITION, data.length - DATA_START_POSITION);
        compressedData.flip();
        return compressedData;
    }

    private byte[] createFollowArray(byte[] data) {
        byte[] next = new byte[DATA_START_POSITION - 1];
        for (int i = 1; i < DATA_START_POSITION; ++i) {
            next[i - 1] = data[i];
        }
        return next;
    }

    @Override
    public byte[] encodeData(byte[] data) throws IOException {
        ByteBuffer result = ByteBuffer.allocate(data.length + 256 + 1);
        result.put(DataHeader.FOLLOW_DATA_ENCODED);
        byte[] followArray = this.generateFollowArray(data);
        result.put(followArray);
        result.put(data[0]);
        for (int i = 1; i < data.length; ++i) {
            int prev = IOUtil.toUnsignedByte(data[i - 1]);
            int current = IOUtil.toUnsignedByte(data[i]);
            int nextFollowValue = IOUtil.toUnsignedByte(followArray[prev]) - current;
            result.put(IOUtil.toSignedByte(nextFollowValue));
        }
        result.flip();
        return result.array();
    }

    private byte[] generateFollowArray(byte[] data) {
        int[][] frequencyMatrix = new int[256][256];
        int[] countsArray = new int[256];
        byte[] followArray = new byte[256];
        for (int i = 0; i < data.length - 1; ++i) {
            int current = IOUtil.toUnsignedByte(data[i]);
            int next = IOUtil.toUnsignedByte(data[i + 1]);
            int[] nArray = frequencyMatrix[current];
            int n = next;
            nArray[n] = nArray[n] + 1;
            int frequencyCount = nArray[n];
            if (frequencyCount <= countsArray[current]) continue;
            countsArray[current] = frequencyCount;
            followArray[current] = IOUtil.toSignedByte(next);
        }
        return followArray;
    }

    @Override
    public byte[] encodeData(byte[] data, byte ignored) throws IOException {
        return this.encodeData(data);
    }

    static {
        DATA_START_POSITION = 257;
    }
}

