/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.ztr.data;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.internal.core.io.ValueSizeStrategy;

public enum DeltaStrategy {
    LEVEL_1{

        @Override
        protected int computeDelta(int u1, int u2, int u3) {
            return u1;
        }
    }
    ,
    LEVEL_2{

        @Override
        protected int computeDelta(int u1, int u2, int u3) {
            return 2 * u1 - u2;
        }
    }
    ,
    LEVEL_3{

        @Override
        protected int computeDelta(int u1, int u2, int u3) {
            return 3 * u1 - 3 * u2 + u3;
        }
    };

    private static final Map<Integer, DeltaStrategy> MAP;

    public static DeltaStrategy getStrategyFor(int level) {
        Integer i = level;
        if (MAP.containsKey(i)) {
            return MAP.get(i);
        }
        throw new IllegalArgumentException("no delta strategy for level " + level);
    }

    public void unCompress(ByteBuffer compressed, ValueSizeStrategy valueSizeStrategy, ByteBuffer out) {
        int u1 = 0;
        int u2 = 0;
        int u3 = 0;
        while (compressed.hasRemaining()) {
            int value = valueSizeStrategy.getNext(compressed) + this.computeDelta(u1, u2, u3);
            valueSizeStrategy.put(out, value);
            u3 = u2;
            u2 = u1;
            u1 = value;
        }
    }

    public void compress(ByteBuffer uncompressed, ValueSizeStrategy valueSizeStrategy, ByteBuffer out) {
        int u1 = 0;
        int u2 = 0;
        int u3 = 0;
        while (uncompressed.hasRemaining()) {
            int next = valueSizeStrategy.getNext(uncompressed);
            int value = next - this.computeDelta(u1, u2, u3);
            valueSizeStrategy.put(out, value);
            u3 = u2;
            u2 = u1;
            u1 = next;
        }
    }

    protected abstract int computeDelta(int var1, int var2, int var3);

    static {
        int mapSize = MapUtil.computeMinHashMapSizeWithoutRehashing(DeltaStrategy.values().length);
        MAP = new HashMap<Integer, DeltaStrategy>(mapSize);
        MAP.put(1, LEVEL_1);
        MAP.put(2, LEVEL_2);
        MAP.put(3, LEVEL_3);
    }
}

