/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.ztr.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jcvi.jillion.internal.core.io.ValueSizeStrategy;
import org.jcvi.jillion.internal.core.seq.trace.sanger.chromat.ztr.data.Data;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.DataHeader;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.DeltaStrategy;

public enum DeltaEncodedData implements Data
{
    BYTE(ValueSizeStrategy.BYTE, DataHeader.BYTE_DELTA_ENCODED),
    SHORT(ValueSizeStrategy.SHORT, DataHeader.SHORT_DELTA_ENCODED),
    INTEGER(ValueSizeStrategy.INTEGER, DataHeader.INTEGER_DELTA_ENCODED){

        @Override
        protected final int getPaddingSize() {
            return 2;
        }
    };

    public static final byte DELTA_LEVEL_1 = 1;
    public static final byte DELTA_LEVEL_2 = 2;
    public static final byte DELTA_LEVEL_3 = 3;
    private final ValueSizeStrategy valueSizeStrategy;
    private final byte headerByte;

    private DeltaEncodedData(ValueSizeStrategy valueSizeStrategy, byte headerByte) {
        this.valueSizeStrategy = valueSizeStrategy;
        this.headerByte = headerByte;
    }

    @Override
    public byte[] parseData(byte[] data) {
        byte level = data[1];
        int startPosition = 2 + this.getPaddingSize();
        ByteBuffer compressed = ByteBuffer.allocate(data.length - startPosition);
        compressed.put(data, startPosition, data.length - startPosition);
        compressed.flip();
        ByteBuffer unCompressedData = ByteBuffer.allocate(compressed.capacity());
        DeltaStrategy.getStrategyFor(level).unCompress(compressed, this.valueSizeStrategy, unCompressedData);
        return unCompressedData.array();
    }

    protected int getPaddingSize() {
        return 0;
    }

    @Override
    public byte[] encodeData(byte[] data) throws IOException {
        return this.encodeData(data, Level.DELTA_LEVEL_1);
    }

    public byte[] encodeData(byte[] data, Level deltaLevel) throws IOException {
        return this.encodeData(data, deltaLevel.level);
    }

    @Override
    public byte[] encodeData(byte[] data, byte level) throws IOException {
        if (level < 1 && level > 3) {
            throw new IllegalArgumentException("level must be between 1 and 3 inclusive: " + level);
        }
        ByteBuffer result = ByteBuffer.allocate(data.length + 2 + this.getPaddingSize());
        result.put(this.headerByte);
        result.put(level);
        for (int i = 0; i < this.getPaddingSize(); ++i) {
            result.put((byte)0);
        }
        DeltaStrategy.getStrategyFor(level).compress(ByteBuffer.wrap(data), this.valueSizeStrategy, result);
        result.flip();
        return Arrays.copyOfRange(result.array(), 0, result.limit());
    }

    public static enum Level {
        DELTA_LEVEL_1(1),
        DELTA_LEVEL_2(2),
        DELTA_LEVEL_3(3);

        private final byte level;

        private Level(byte level) {
            this.level = level;
        }

        public byte getLevel() {
            return this.level;
        }
    }
}

