/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.ztr.data;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jcvi.jillion.internal.core.seq.trace.sanger.chromat.ztr.data.Data;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.DataHeader;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.DeltaEncodedData;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.FollowData;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.RawData;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.RunLengthEncodedData;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.ShrinkToEightBitData;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.ZLibData;

public final class DataFactory {
    private static final Map<Byte, Data> DATA_MAP;

    private DataFactory() {
    }

    public static Data getDataImplementation(byte[] data) throws IOException {
        if (data == null || data.length < 1) {
            throw new IOException("can not parse data format");
        }
        Byte format = data[0];
        Data dataImpl = DATA_MAP.get(format);
        if (dataImpl == null) {
            throw new IOException("format not supported : " + format);
        }
        return dataImpl;
    }

    static {
        HashMap<Byte, Enum> map = new HashMap<Byte, Enum>();
        map.put(DataHeader.RAW, RawData.INSTANCE);
        map.put(DataHeader.RUN_LENGTH_ENCODED, RunLengthEncodedData.INSTANCE);
        map.put(DataHeader.ZLIB_ENCODED, ZLibData.INSTANCE);
        map.put(DataHeader.BYTE_DELTA_ENCODED, DeltaEncodedData.BYTE);
        map.put(DataHeader.SHORT_DELTA_ENCODED, DeltaEncodedData.SHORT);
        map.put(DataHeader.INTEGER_DELTA_ENCODED, DeltaEncodedData.INTEGER);
        map.put(DataHeader.SHRINK_SHORT_TO_BYTE_ENCODED, ShrinkToEightBitData.SHORT_TO_BYTE);
        map.put(DataHeader.SHRINK_INTEGER_TO_BYTE_ENCODED, ShrinkToEightBitData.INTEGER_TO_BYTE);
        map.put(DataHeader.FOLLOW_DATA_ENCODED, FollowData.INSTANCE);
        DATA_MAP = Collections.unmodifiableMap(map);
    }
}

