/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.ztr.chunk;

import java.util.HashMap;
import java.util.Map;
import org.jcvi.jillion.internal.trace.chromat.ztr.chunk.ChunkException;

public enum ChunkType {
    SAMPLES("SMP4"),
    BASECALLS("BASE"),
    POSITIONS("BPOS"),
    CONFIDENCE("CNF4"),
    COMMENTS("TEXT"),
    CLIP("CLIP");

    private static final Map<String, ChunkType> MAP;
    private final String typeName;

    private ChunkType(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static ChunkType getChunkFor(String header) throws ChunkException {
        if (MAP.containsKey(header)) {
            return MAP.get(header);
        }
        throw new ChunkException(String.format("header '%s' is unknown", header));
    }

    static {
        MAP = new HashMap<String, ChunkType>();
        for (ChunkType type : ChunkType.values()) {
            MAP.put(type.getTypeName(), type);
        }
    }
}

