/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.ztr.chunk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.pos.Position;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.internal.core.seq.trace.sanger.chromat.ztr.data.Data;
import org.jcvi.jillion.internal.trace.chromat.ztr.ZTRUtil;
import org.jcvi.jillion.internal.trace.chromat.ztr.chunk.ChunkException;
import org.jcvi.jillion.internal.trace.chromat.ztr.chunk.ChunkType;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.DataFactory;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.RawData;
import org.jcvi.jillion.trace.chromat.ChannelGroup;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.ChromatogramFileVisitor;
import org.jcvi.jillion.trace.chromat.ztr.ZtrChromatogram;
import org.jcvi.jillion.trace.chromat.ztr.ZtrChromatogramBuilder;
import org.jcvi.jillion.trace.chromat.ztr.ZtrChromatogramFileVisitor;

public enum Chunk {
    BASE{

        @Override
        protected void parseData(byte[] unEncodedData, ZtrChromatogramBuilder builder) throws IOException {
            int numberOfBases = unEncodedData.length - 1;
            ByteBuffer buf = ByteBuffer.allocate(numberOfBases);
            buf.put(unEncodedData, 1, numberOfBases);
            builder.basecalls(new NucleotideSequenceBuilder(new String(buf.array(), IOUtil.UTF_8)).build());
        }

        @Override
        protected NucleotideSequence parseData(byte[] unEncodedData, ChromatogramFileVisitor visitor, NucleotideSequence ignored) throws IOException {
            int numberOfBases = unEncodedData.length - 1;
            ByteBuffer buf = ByteBuffer.allocate(numberOfBases);
            buf.put(unEncodedData, 1, numberOfBases);
            NucleotideSequence basecalls = new NucleotideSequenceBuilder(new String(buf.array(), IOUtil.UTF_8)).build();
            visitor.visitBasecalls(basecalls);
            return basecalls;
        }

        @Override
        public byte[] encodeChunk(Chromatogram ztrChromatogram) throws IOException {
            String basecalls = ztrChromatogram.getNucleotideSequence().toString();
            ByteBuffer buffer = ByteBuffer.allocate(basecalls.length() + 1);
            buffer.put((byte)0);
            for (int i = 0; i < basecalls.length(); ++i) {
                buffer.put((byte)basecalls.charAt(i));
            }
            return buffer.array();
        }
    }
    ,
    POSITIONS{

        @Override
        protected void parseData(byte[] unEncodedData, ZtrChromatogramBuilder builder) throws IOException {
            int numberOfBases = (unEncodedData.length - 1) / 4;
            ShortBuffer peaks = ShortBuffer.allocate(numberOfBases);
            ByteBuffer input = ByteBuffer.wrap(unEncodedData);
            input.position(4);
            while (input.hasRemaining()) {
                peaks.put((short)input.getInt());
            }
            builder.peaks(peaks.array());
        }

        @Override
        protected NucleotideSequence parseData(byte[] unEncodedData, ChromatogramFileVisitor visitor, NucleotideSequence basecalls) throws IOException {
            int numberOfBases = (unEncodedData.length - 1) / 4;
            ShortBuffer peaks = ShortBuffer.allocate(numberOfBases);
            ByteBuffer input = ByteBuffer.wrap(unEncodedData);
            input.position(4);
            while (input.hasRemaining()) {
                peaks.put((short)input.getInt());
            }
            visitor.visitPeaks(peaks.array());
            return basecalls;
        }

        @Override
        public byte[] encodeChunk(Chromatogram ztrChromatogram) throws IOException {
            PositionSequence peaks = ztrChromatogram.getPeakSequence();
            ByteBuffer buffer = ByteBuffer.allocate((int)peaks.getLength() * 4 + 4);
            buffer.putInt(0);
            for (Position peak : peaks) {
                buffer.putInt(peak.getValue());
            }
            return buffer.array();
        }
    }
    ,
    CLIP{

        @Override
        protected void parseData(byte[] unEncodedData, ZtrChromatogramBuilder builder) throws IOException {
            if (unEncodedData.length != 9) {
                throw new IOException("Invalid DefaultClip size, num of bytes = " + unEncodedData.length);
            }
            ByteBuffer buf = ByteBuffer.wrap(unEncodedData);
            buf.position(1);
            builder.clip(Range.of(buf.getInt(), (long)buf.getInt()));
        }

        @Override
        protected NucleotideSequence parseData(byte[] unEncodedData, ChromatogramFileVisitor visitor, NucleotideSequence basecalls) throws IOException {
            if (unEncodedData.length != 9) {
                throw new IOException("Invalid DefaultClip size, num of bytes = " + unEncodedData.length);
            }
            ByteBuffer buf = ByteBuffer.wrap(unEncodedData);
            buf.position(1);
            Range clipRange = Range.of(buf.getInt(), (long)buf.getInt());
            if (visitor instanceof ZtrChromatogramFileVisitor) {
                ((ZtrChromatogramFileVisitor)visitor).visitClipRange(clipRange);
            }
            return basecalls;
        }

        @Override
        public byte[] encodeChunk(Chromatogram ztrChromatogram) throws IOException {
            Range clip = null;
            if (ztrChromatogram instanceof ZtrChromatogram) {
                clip = ((ZtrChromatogram)ztrChromatogram).getClip();
            }
            if (clip == null) {
                clip = Range.of(0L, 0L);
            }
            ByteBuffer buffer = ByteBuffer.allocate(9);
            buffer.put((byte)0);
            buffer.putInt((int)clip.getBegin());
            buffer.putInt((int)clip.getEnd());
            return buffer.array();
        }
    }
    ,
    CONFIDENCES{
        EnumSet<Nucleotide> notA = EnumSet.of(Nucleotide.Cytosine, Nucleotide.Guanine, Nucleotide.Thymine);
        EnumSet<Nucleotide> notC = EnumSet.of(Nucleotide.Adenine, Nucleotide.Guanine, Nucleotide.Thymine);
        EnumSet<Nucleotide> notG = EnumSet.of(Nucleotide.Adenine, Nucleotide.Cytosine, Nucleotide.Thymine);
        EnumSet<Nucleotide> notACorG = EnumSet.of(Nucleotide.Adenine, Nucleotide.Cytosine, Nucleotide.Guanine);
        Map<Nucleotide, Set<Nucleotide>> otherChannelMap = new EnumMap<Nucleotide, Set<Nucleotide>>(Nucleotide.class);
        {
            this.otherChannelMap.put(Nucleotide.Adenine, this.notA);
            this.otherChannelMap.put(Nucleotide.Cytosine, this.notC);
            this.otherChannelMap.put(Nucleotide.Guanine, this.notG);
        }

        private Set<Nucleotide> getOtherChannelsThan(Nucleotide channel) {
            if (this.otherChannelMap.containsKey(channel)) {
                return this.otherChannelMap.get(channel);
            }
            return this.notACorG;
        }

        @Override
        protected void parseData(byte[] unEncodedData, ZtrChromatogramBuilder builder) throws IOException {
            NucleotideSequence basecalls = new NucleotideSequenceBuilder(builder.basecalls()).build();
            int numberOfBases = (int)basecalls.getLength();
            ByteBuffer aConfidence = ByteBuffer.allocate(numberOfBases);
            ByteBuffer cConfidence = ByteBuffer.allocate(numberOfBases);
            ByteBuffer gConfidence = ByteBuffer.allocate(numberOfBases);
            ByteBuffer tConfidence = ByteBuffer.allocate(numberOfBases);
            ByteBuffer calledConfidence = ByteBuffer.wrap(unEncodedData);
            ByteBuffer unCalledConfidence = calledConfidence.slice();
            calledConfidence.position(1);
            unCalledConfidence.position(1 + numberOfBases);
            this.populateConfidenceBuffers(basecalls, aConfidence, cConfidence, gConfidence, tConfidence, calledConfidence, unCalledConfidence);
            builder.aQualities(aConfidence.array());
            builder.cConfidence(cConfidence.array());
            builder.gQualities(gConfidence.array());
            builder.tQualities(tConfidence.array());
        }

        private void populateConfidenceBuffers(NucleotideSequence basecalls, ByteBuffer aConfidence, ByteBuffer cConfidence, ByteBuffer gConfidence, ByteBuffer tConfidence, ByteBuffer calledConfidence, ByteBuffer unCalledConfidence) {
            int length = (int)basecalls.getLength();
            for (int i = 0; i < length; ++i) {
                char currentChar = ((Nucleotide)basecalls.get(i)).getCharacter().charValue();
                this.populateConfidenceBuffers(currentChar, aConfidence, cConfidence, gConfidence, tConfidence, calledConfidence, unCalledConfidence);
            }
        }

        private void populateConfidenceBuffers(char currentChar, ByteBuffer aConfidence, ByteBuffer cConfidence, ByteBuffer gConfidence, ByteBuffer tConfidence, ByteBuffer calledConfidence, ByteBuffer unCalledConfidence) {
            if (this.matchesCharacterIgnoringCase(currentChar, 'A')) {
                this.setConfidences(calledConfidence, unCalledConfidence, aConfidence, Arrays.asList(cConfidence, gConfidence, tConfidence));
            } else if (this.matchesCharacterIgnoringCase(currentChar, 'C')) {
                this.setConfidences(calledConfidence, unCalledConfidence, cConfidence, Arrays.asList(aConfidence, gConfidence, tConfidence));
            } else if (this.matchesCharacterIgnoringCase(currentChar, 'G')) {
                this.setConfidences(calledConfidence, unCalledConfidence, gConfidence, Arrays.asList(aConfidence, cConfidence, tConfidence));
            } else {
                this.setConfidences(calledConfidence, unCalledConfidence, tConfidence, Arrays.asList(aConfidence, cConfidence, gConfidence));
            }
        }

        private boolean matchesCharacterIgnoringCase(char c, char charToMatch) {
            return Character.toLowerCase(c) == charToMatch || Character.toUpperCase(c) == charToMatch;
        }

        private void setConfidences(ByteBuffer calledConfidence, ByteBuffer unCalledConfidence, ByteBuffer calledconfidenceChannel, List<ByteBuffer> uncalledConfidenceChannels) {
            calledconfidenceChannel.put(calledConfidence.get());
            for (ByteBuffer uncalledBuf : uncalledConfidenceChannels) {
                uncalledBuf.put(unCalledConfidence.get());
            }
        }

        @Override
        protected NucleotideSequence parseData(byte[] unEncodedData, ChromatogramFileVisitor visitor, NucleotideSequence basecalls) throws IOException {
            int numberOfBases = (int)basecalls.getLength();
            ByteBuffer aConfidence = ByteBuffer.allocate(numberOfBases);
            ByteBuffer cConfidence = ByteBuffer.allocate(numberOfBases);
            ByteBuffer gConfidence = ByteBuffer.allocate(numberOfBases);
            ByteBuffer tConfidence = ByteBuffer.allocate(numberOfBases);
            ByteBuffer calledConfidence = ByteBuffer.wrap(unEncodedData);
            ByteBuffer unCalledConfidence = calledConfidence.slice();
            calledConfidence.position(1);
            unCalledConfidence.position(1 + numberOfBases);
            this.populateConfidenceBuffers(basecalls, aConfidence, cConfidence, gConfidence, tConfidence, calledConfidence, unCalledConfidence);
            visitor.visitAConfidence(aConfidence.array());
            visitor.visitCConfidence(cConfidence.array());
            visitor.visitGConfidence(gConfidence.array());
            visitor.visitTConfidence(tConfidence.array());
            return basecalls;
        }

        @Override
        public byte[] encodeChunk(Chromatogram ztrChromatogram) throws IOException {
            ChannelGroup channelGroup = ztrChromatogram.getChannelGroup();
            NucleotideSequence nucleotideSequence = ztrChromatogram.getNucleotideSequence();
            int sequenceLength = (int)nucleotideSequence.getLength();
            ByteBuffer calledBaseConfidences = ByteBuffer.allocate(sequenceLength);
            ByteBuffer otherConfidences = ByteBuffer.allocate(sequenceLength * 3);
            int i = 0;
            for (Nucleotide base : nucleotideSequence) {
                calledBaseConfidences.put(((PhredQuality)channelGroup.getChannel(base).getQualitySequence().get(i)).getQualityScore());
                for (Nucleotide other : this.getOtherChannelsThan(base)) {
                    otherConfidences.put(((PhredQuality)channelGroup.getChannel(other).getQualitySequence().get(i)).getQualityScore());
                }
                ++i;
            }
            ByteBuffer result = ByteBuffer.allocate(sequenceLength * 4 + 1);
            result.put((byte)0);
            result.put(calledBaseConfidences.array());
            result.put(otherConfidences.array());
            return result.array();
        }
    }
    ,
    SMP4{

        @Override
        public void parseData(byte[] unEncodedData, ZtrChromatogramBuilder builder) throws IOException {
            ShortBuffer buf = ByteBuffer.wrap(unEncodedData).asShortBuffer();
            buf.position(1);
            int length = buf.capacity() - 1;
            int numberOfPositions = length / 4;
            ShortBuffer aPositions = ShortBuffer.allocate(numberOfPositions);
            ShortBuffer cPositions = ShortBuffer.allocate(numberOfPositions);
            ShortBuffer gPositions = ShortBuffer.allocate(numberOfPositions);
            ShortBuffer tPositions = ShortBuffer.allocate(numberOfPositions);
            this.populatePositionData(buf, aPositions);
            this.populatePositionData(buf, cPositions);
            this.populatePositionData(buf, gPositions);
            this.populatePositionData(buf, tPositions);
            builder.aPositions(aPositions.array());
            builder.cPositions(cPositions.array());
            builder.gPositions(gPositions.array());
            builder.tPositions(tPositions.array());
        }

        private void populatePositionData(ShortBuffer buf, ShortBuffer aPositions) {
            for (int i = 0; i < aPositions.capacity(); ++i) {
                aPositions.put(buf.get());
            }
        }

        @Override
        protected NucleotideSequence parseData(byte[] unEncodedData, ChromatogramFileVisitor visitor, NucleotideSequence basecalls) throws IOException {
            ShortBuffer buf = ByteBuffer.wrap(unEncodedData).asShortBuffer();
            buf.position(1);
            int length = buf.capacity() - 1;
            int numberOfPositions = length / 4;
            ShortBuffer aPositions = ShortBuffer.allocate(numberOfPositions);
            ShortBuffer cPositions = ShortBuffer.allocate(numberOfPositions);
            ShortBuffer gPositions = ShortBuffer.allocate(numberOfPositions);
            ShortBuffer tPositions = ShortBuffer.allocate(numberOfPositions);
            this.populatePositionData(buf, aPositions);
            this.populatePositionData(buf, cPositions);
            this.populatePositionData(buf, gPositions);
            this.populatePositionData(buf, tPositions);
            visitor.visitAPositions(aPositions.array());
            visitor.visitCPositions(cPositions.array());
            visitor.visitGPositions(gPositions.array());
            visitor.visitTPositions(tPositions.array());
            return basecalls;
        }

        @Override
        public byte[] encodeChunk(Chromatogram ztrChromatogram) throws IOException {
            int numTracePositions = ztrChromatogram.getNumberOfTracePositions();
            ChannelGroup channelGroup = ztrChromatogram.getChannelGroup();
            ByteBuffer result = ByteBuffer.allocate(8 * numTracePositions + 2);
            result.putShort((short)0);
            for (Position pos : channelGroup.getAChannel().getPositionSequence()) {
                result.putShort(IOUtil.toSignedShort(pos.getValue()));
            }
            for (Position pos : channelGroup.getCChannel().getPositionSequence()) {
                result.putShort(IOUtil.toSignedShort(pos.getValue()));
            }
            for (Position pos : channelGroup.getGChannel().getPositionSequence()) {
                result.putShort(IOUtil.toSignedShort(pos.getValue()));
            }
            for (Position pos : channelGroup.getTChannel().getPositionSequence()) {
                result.putShort(IOUtil.toSignedShort(pos.getValue()));
            }
            return result.array();
        }
    }
    ,
    COMMENTS{

        @Override
        protected void parseData(byte[] decodedData, ZtrChromatogramBuilder builder) throws IOException {
            ByteArrayInputStream in = new ByteArrayInputStream(decodedData);
            builder.comments(this.parseText(in));
        }

        protected Map<String, String> parseText(InputStream in) throws IOException {
            LinkedHashMap<Object, String> textProps = new LinkedHashMap<Object, String>();
            try (Scanner scanner = null;){
                Object key;
                in.read();
                scanner = new Scanner(in, "UTF-8").useDelimiter("\u0000+");
                while (scanner.hasNext()) {
                    key = scanner.next();
                    String value = scanner.next();
                    textProps.put(key, value);
                }
                key = textProps;
                return key;
            }
        }

        @Override
        protected NucleotideSequence parseData(byte[] decodedData, ChromatogramFileVisitor visitor, NucleotideSequence basecalls) throws IOException {
            ByteArrayInputStream in = new ByteArrayInputStream(decodedData);
            Map<String, String> comments = this.parseText(in);
            visitor.visitComments(comments);
            return basecalls;
        }

        @Override
        public byte[] encodeChunk(Chromatogram ztrChromatogram) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            for (Map.Entry<String, String> entry : ztrChromatogram.getComments().entrySet()) {
                try {
                    out.write(entry.getKey().getBytes("UTF-8"));
                    out.write(0);
                    out.write(entry.getValue().getBytes("UTF-8"));
                    out.write(0);
                }
                catch (IOException e) {
                    throw new IOException(String.format("error writing comment key='%s' value ='%s'", entry.getKey(), entry.getValue()), e);
                }
            }
            out.write(0);
            byte[] ret = out.toByteArray();
            IOUtil.closeAndIgnoreErrors((Closeable)out);
            return ret;
        }
    };

    private static final Map<ChunkType, Chunk> CHUNK_MAP;
    private static final byte PADDING_BYTE = 0;

    public static Chunk getChunk(String chunkHeader) throws ChunkException {
        return CHUNK_MAP.get((Object)ChunkType.getChunkFor(chunkHeader));
    }

    public void parseChunk(ZtrChromatogramBuilder builder, InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("inputStream can not be null");
        }
        if (builder == null) {
            throw new IOException("chromoStruct can not be null");
        }
        this.readMetaData(inputStream);
        this.readData(builder, inputStream);
    }

    public NucleotideSequence parseChunk(InputStream inputStream, ChromatogramFileVisitor visitor, NucleotideSequence basecalls) throws IOException {
        if (inputStream == null) {
            throw new IOException("inputStream can not be null");
        }
        this.readMetaData(inputStream);
        return this.readData(inputStream, visitor, basecalls);
    }

    protected void readMetaData(InputStream inputStream) throws IOException {
        try {
            long length = this.readLength(inputStream);
            IOUtil.blockingSkip(inputStream, length);
        }
        catch (IOException ioEx) {
            throw new IOException("error reading chunk meta data", ioEx);
        }
    }

    protected int readLength(InputStream inputStream) throws IOException {
        try {
            byte[] lengthArray = this.readLengthFromInputStream(inputStream);
            long length = ZTRUtil.readInt(lengthArray);
            if (length < 0L || length > Integer.MAX_VALUE) {
                length = ZTRUtil.readInt(IOUtil.switchEndian(lengthArray));
            }
            return (int)length;
        }
        catch (IOException e) {
            throw new IOException("error reading chunk length", e);
        }
    }

    private byte[] readLengthFromInputStream(InputStream inputStream) throws IOException {
        byte[] lengthArray = new byte[4];
        IOUtil.blockingRead(inputStream, lengthArray);
        return lengthArray;
    }

    private void readData(ZtrChromatogramBuilder builder, InputStream inputStream) throws IOException {
        int length = this.readLength(inputStream);
        this.parseData(this.decodeChunk(inputStream, length), builder);
    }

    private NucleotideSequence readData(InputStream inputStream, ChromatogramFileVisitor visitor, NucleotideSequence basecalls) throws IOException {
        int length = this.readLength(inputStream);
        return this.parseData(this.decodeChunk(inputStream, length), visitor, basecalls);
    }

    protected abstract void parseData(byte[] var1, ZtrChromatogramBuilder var2) throws IOException;

    protected abstract NucleotideSequence parseData(byte[] var1, ChromatogramFileVisitor var2, NucleotideSequence var3) throws IOException;

    public abstract byte[] encodeChunk(Chromatogram var1) throws IOException;

    protected byte[] decodeChunk(InputStream inputStream, int datalength) throws IOException {
        try {
            boolean stillEncoded = true;
            byte[] data = this.readData(inputStream, datalength);
            while (stillEncoded) {
                Data dataImplementation = DataFactory.getDataImplementation(data);
                if (dataImplementation instanceof RawData) {
                    stillEncoded = false;
                    continue;
                }
                data = dataImplementation.parseData(data);
            }
            return data;
        }
        catch (IOException e) {
            throw new IOException("error decoding chunk", e);
        }
    }

    private byte[] readData(InputStream inputStream, int datalength) throws IOException, IOException {
        byte[] data = new byte[datalength];
        try {
            IOUtil.blockingRead(inputStream, data);
        }
        catch (EOFException e) {
            throw new IOException("invalid datalength field", e);
        }
        return data;
    }

    static {
        HashMap<ChunkType, Chunk> map = new HashMap<ChunkType, Chunk>();
        map.put(ChunkType.SAMPLES, SMP4);
        map.put(ChunkType.BASECALLS, BASE);
        map.put(ChunkType.POSITIONS, POSITIONS);
        map.put(ChunkType.CONFIDENCE, CONFIDENCES);
        map.put(ChunkType.COMMENTS, COMMENTS);
        map.put(ChunkType.CLIP, CLIP);
        CHUNK_MAP = Collections.unmodifiableMap(map);
    }
}

