/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.ztr;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.internal.core.seq.trace.sanger.chromat.ztr.data.Data;
import org.jcvi.jillion.internal.trace.chromat.ztr.ZTRUtil;
import org.jcvi.jillion.internal.trace.chromat.ztr.ZtrChromatogramWriter;
import org.jcvi.jillion.internal.trace.chromat.ztr.chunk.Chunk;
import org.jcvi.jillion.internal.trace.chromat.ztr.chunk.ChunkType;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.DeltaEncodedData;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.FollowData;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.RunLengthEncodedData;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.ShrinkToEightBitData;
import org.jcvi.jillion.internal.trace.chromat.ztr.data.ZLibData;
import org.jcvi.jillion.trace.chromat.Chromatogram;

public final class DefaultZTRChromatogramWriterBuilder
implements Builder<ZtrChromatogramWriter> {
    private final ChunkEncoderBuilder basecallEncoder = new ChunkEncoderBuilder(Chunk.BASE, ChunkType.BASECALLS);
    private final ChunkEncoderBuilder positionsEncoder = new ChunkEncoderBuilder(Chunk.SMP4, ChunkType.SAMPLES);
    private final ChunkEncoderBuilder confidenceEncoder = new ChunkEncoderBuilder(Chunk.CONFIDENCES, ChunkType.CONFIDENCE);
    private final ChunkEncoderBuilder commentsEncoder = new ChunkEncoderBuilder(Chunk.COMMENTS, ChunkType.COMMENTS);
    private final ChunkEncoderBuilder clipEncoder = new ChunkEncoderBuilder(Chunk.CLIP, ChunkType.CLIP);
    private final ChunkEncoderBuilder peaksEncoder = new ChunkEncoderBuilder(Chunk.POSITIONS, ChunkType.POSITIONS);

    public ChunkEncoderBuilder forBasecallChunkEncoder() {
        return this.basecallEncoder;
    }

    public ChunkEncoderBuilder forPositionsChunkEncoder() {
        return this.positionsEncoder;
    }

    public ChunkEncoderBuilder forConfidenceChunkEncoder() {
        return this.confidenceEncoder;
    }

    public ChunkEncoderBuilder forCommentsChunkEncoder() {
        return this.commentsEncoder;
    }

    public ChunkEncoderBuilder forClipPointsChunkEncoder() {
        return this.clipEncoder;
    }

    public ChunkEncoderBuilder forPeaksChunkEncoder() {
        return this.peaksEncoder;
    }

    @Override
    public ZtrChromatogramWriter build() {
        return new DefaultZTRChromatogramWriter(this.basecallEncoder.build(), this.positionsEncoder.build(), this.confidenceEncoder.build(), this.commentsEncoder.build(), this.clipEncoder.build(), this.peaksEncoder.build());
    }

    private static final class DefaultZTRChromatogramWriter
    implements ZtrChromatogramWriter {
        private static final byte[] ZTR_VERSION = new byte[]{1, 2};
        private final ChunkEncoder basecallEncoder;
        private final ChunkEncoder peaksEncoder;
        private final ChunkEncoder positionsEncoder;
        private final ChunkEncoder confidenceEncoder;
        private final ChunkEncoder commentsEncoder;
        private final ChunkEncoder clipEncoder;

        private DefaultZTRChromatogramWriter(ChunkEncoder basecallEncoder, ChunkEncoder positionsEncoder, ChunkEncoder confidenceEncoder, ChunkEncoder commentsEncoder, ChunkEncoder clipEncoder, ChunkEncoder peaksEncoder) {
            this.basecallEncoder = basecallEncoder;
            this.positionsEncoder = positionsEncoder;
            this.confidenceEncoder = confidenceEncoder;
            this.commentsEncoder = commentsEncoder;
            this.clipEncoder = clipEncoder;
            this.peaksEncoder = peaksEncoder;
        }

        @Override
        public void write(Chromatogram chromatogram, OutputStream out) throws IOException {
            if (chromatogram == null) {
                throw new NullPointerException("chromatogram can not be null");
            }
            try {
                out.write(ZTRUtil.getMagicNumber());
                out.write(ZTR_VERSION);
                out.write(this.positionsEncoder.encode(chromatogram));
                out.write(this.basecallEncoder.encode(chromatogram));
                out.write(this.peaksEncoder.encode(chromatogram));
                out.write(this.confidenceEncoder.encode(chromatogram));
                out.write(this.commentsEncoder.encode(chromatogram));
                out.write(this.clipEncoder.encode(chromatogram));
            }
            catch (IOException e) {
                throw new IOException("error writing ZTR", e);
            }
        }
    }

    public static class ChunkEncoderBuilder
    implements Builder<ChunkEncoder> {
        private final Chunk chunk;
        private final ChunkType chunkType;
        private final List<DataEncoder> encoders = new ArrayList<DataEncoder>();

        public ChunkEncoderBuilder(Chunk chunk, ChunkType chunkType) {
            if (chunk == null) {
                throw new NullPointerException("chunk can not be null");
            }
            if (chunkType == null) {
                throw new NullPointerException("chunkType can not be null");
            }
            this.chunk = chunk;
            this.chunkType = chunkType;
        }

        public ChunkEncoderBuilder addRunLengthEncoder() {
            return this.addRunLengthEncoder((byte)-106);
        }

        public ChunkEncoderBuilder addZLibEncoder() {
            this.encoders.add(new DataEncoder((Data)ZLibData.INSTANCE));
            return this;
        }

        public ChunkEncoderBuilder addFollowEncoder() {
            this.encoders.add(new DataEncoder((Data)FollowData.INSTANCE));
            return this;
        }

        public ChunkEncoderBuilder addShrinkEncoder(ShrinkToEightBitData shrinker) {
            this.encoders.add(new DataEncoder((Data)shrinker));
            return this;
        }

        public ChunkEncoderBuilder addRunLengthEncoder(byte guard) {
            this.encoders.add(new DataEncoder(RunLengthEncodedData.INSTANCE, guard));
            return this;
        }

        public ChunkEncoderBuilder addDeltaEncoder(DeltaEncodedData deltaEncoder, DeltaEncodedData.Level deltaLevel) {
            this.encoders.add(new DataEncoder(deltaEncoder, deltaLevel.getLevel()));
            return this;
        }

        @Override
        public ChunkEncoder build() {
            return new ChunkEncoder(this.chunkType, this.chunk, this.encoders);
        }
    }

    private static final class ChunkEncoder {
        private final ChunkType type;
        private final Chunk chunk;
        private final List<DataEncoder> dataEncoders;

        private ChunkEncoder(ChunkType type, Chunk chunk, List<DataEncoder> dataEncoders) {
            this.type = type;
            this.chunk = chunk;
            this.dataEncoders = dataEncoders;
        }

        public byte[] encode(Chromatogram chromatogram) throws IOException {
            byte[] currentData = this.chunk.encodeChunk(chromatogram);
            for (DataEncoder encoder : this.dataEncoders) {
                currentData = encoder.encode(currentData);
            }
            ByteBuffer encodedData = ByteBuffer.allocate(12 + currentData.length);
            try {
                encodedData.put(this.type.getTypeName().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException("could not encode chunk type " + (Object)((Object)this.type), e);
            }
            encodedData.putInt(0);
            encodedData.putInt(currentData.length);
            encodedData.put(currentData);
            return encodedData.array();
        }
    }

    private static final class DataEncoder {
        private final Data data;
        private final byte optionalParameter;

        private DataEncoder(Data data) {
            this(data, 0);
        }

        private DataEncoder(Data data, byte optionalParameter) {
            if (data == null) {
                throw new NullPointerException("data can not be null");
            }
            this.data = data;
            this.optionalParameter = optionalParameter;
        }

        private byte[] encode(byte[] data) throws IOException {
            return this.data.encodeData(data, this.optionalParameter);
        }
    }
}

