/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.scf.section;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.internal.trace.chromat.scf.SCFUtils;
import org.jcvi.jillion.internal.trace.chromat.scf.header.pos.PositionStrategy;
import org.jcvi.jillion.internal.trace.chromat.scf.section.AbstractSampleSectionCodec;

public class Version3SampleSectionCodec
extends AbstractSampleSectionCodec {
    @Override
    protected void extractActualPositions(PositionStrategy positionStrategy, short[][] positions) {
        for (int channel = 0; channel < 4; ++channel) {
            SCFUtils.deltaDeltaDecode(positions[channel]);
        }
    }

    @Override
    protected short[][] parseRawPositions(DataInputStream in, int numberOfSamples, PositionStrategy positionStrategy) throws IOException {
        short[][] positions = new short[4][numberOfSamples];
        for (int channel = 0; channel < 4; ++channel) {
            for (int i = 0; i < numberOfSamples; ++i) {
                try {
                    positions[channel][i] = positionStrategy.getPosition(in);
                    continue;
                }
                catch (EOFException e) {
                    return positions;
                }
            }
        }
        return positions;
    }

    @Override
    protected void writePositionsToBuffer(PositionStrategy positionStrategy, PositionSequence aPositions, PositionSequence cPositions, PositionSequence gPositions, PositionSequence tPositions, ByteBuffer buffer) {
        this.bulkPut(positionStrategy, SCFUtils.deltaDeltaEncode(aPositions), buffer);
        this.bulkPut(positionStrategy, SCFUtils.deltaDeltaEncode(cPositions), buffer);
        this.bulkPut(positionStrategy, SCFUtils.deltaDeltaEncode(gPositions), buffer);
        this.bulkPut(positionStrategy, SCFUtils.deltaDeltaEncode(tPositions), buffer);
    }

    private void bulkPut(PositionStrategy positionStrategy, ShortBuffer positions, ByteBuffer buffer) {
        while (positions.hasRemaining()) {
            positionStrategy.setPosition(positions.get(), buffer);
        }
    }
}

