/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.scf.section;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.trace.chromat.scf.header.SCFHeader;
import org.jcvi.jillion.internal.trace.chromat.scf.section.EncodedSection;
import org.jcvi.jillion.internal.trace.chromat.scf.section.Section;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionDecoderException;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.ChromatogramFileVisitor;
import org.jcvi.jillion.trace.chromat.scf.PrivateData;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogram;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogramBuilder;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogramFileVisitor;

public class PrivateDataCodec
implements SectionCodec {
    private static final byte[] EMPTY = new byte[0];

    @Override
    public EncodedSection encode(Chromatogram c, SCFHeader header) throws IOException {
        PrivateData privateData = c instanceof ScfChromatogram ? ((ScfChromatogram)c).getPrivateData() : null;
        if (privateData == null || privateData.getBytes() == null) {
            header.setPrivateDataSize(0);
            return new EncodedSection(ByteBuffer.wrap(EMPTY), Section.PRIVATE_DATA);
        }
        byte[] rawArray = privateData.getBytes();
        header.setPrivateDataSize(rawArray.length);
        return new EncodedSection(ByteBuffer.wrap(rawArray), Section.PRIVATE_DATA);
    }

    @Override
    public long decode(DataInputStream in, long currentOffset, SCFHeader header, ScfChromatogramBuilder c) throws SectionDecoderException {
        long bytesToSkip = Math.max(0L, (long)header.getPrivateDataOffset() - currentOffset);
        try {
            IOUtil.blockingSkip(in, bytesToSkip);
            int privateDataSize = header.getPrivateDataSize();
            if (privateDataSize == 0) {
                c.privateData(null);
            } else {
                byte[] privateData = new byte[privateDataSize];
                int bytesRead = in.read(privateData);
                if (bytesRead != privateDataSize) {
                    throw new SectionDecoderException("could not read entire private data section");
                }
                c.privateData(privateData);
            }
            return currentOffset + bytesToSkip + (long)privateDataSize;
        }
        catch (IOException e) {
            throw new SectionDecoderException("error trying to decode Private Data", e);
        }
    }

    @Override
    public long decode(DataInputStream in, long currentOffset, SCFHeader header, ChromatogramFileVisitor c) throws SectionDecoderException {
        long bytesToSkip = (long)header.getPrivateDataOffset() - currentOffset;
        try {
            IOUtil.blockingSkip(in, bytesToSkip);
            int privateDataSize = header.getPrivateDataSize();
            if (privateDataSize != 0) {
                byte[] privateData = new byte[privateDataSize];
                int bytesRead = in.read(privateData);
                if (bytesRead != privateDataSize) {
                    throw new SectionDecoderException("could not read entire private data section");
                }
                if (c instanceof ScfChromatogramFileVisitor) {
                    ((ScfChromatogramFileVisitor)c).visitPrivateData(privateData);
                }
            }
            return currentOffset + bytesToSkip + (long)privateDataSize;
        }
        catch (IOException e) {
            throw new SectionDecoderException("error trying to decode Private Data", e);
        }
    }
}

