/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.scf.section;

import java.util.EnumMap;
import java.util.Map;
import org.jcvi.jillion.internal.trace.chromat.scf.header.SCFHeader;
import org.jcvi.jillion.internal.trace.chromat.scf.section.CommentSectionCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.section.NullSectionCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.section.PrivateDataCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.section.Section;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionCodecFactory;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionDecoder;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionEncoder;
import org.jcvi.jillion.internal.trace.chromat.scf.section.Version2BasesSectionCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.section.Version2SampleSectionCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.section.Version3BasesSectionCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.section.Version3SampleSectionCodec;

public enum DefaultSectionCodecFactory implements SectionCodecFactory
{
    INSTANCE;

    private static final SectionCodec NULL_CODEC;
    private static final SectionCodec COMMENT_CODEC;
    private static final SectionCodec PRIVATE_DATA_CODEC;
    private static final float THREE = 3.0f;
    private static final Map<Section, SectionCodec> VERSION_3_MAP;
    private static final Map<Section, SectionCodec> VERSION_2_MAP;

    @Override
    public SectionDecoder getSectionParserFor(Section s, SCFHeader header) {
        this.cannotBeNull(s);
        if (header == null) {
            throw new IllegalArgumentException("header can not be null");
        }
        if (header.getVersion() < 3.0f) {
            return DefaultSectionCodecFactory.getSectionCodecFrom(VERSION_2_MAP, s);
        }
        return DefaultSectionCodecFactory.getSectionCodecFrom(VERSION_3_MAP, s);
    }

    private static SectionCodec getSectionCodecFrom(Map<Section, SectionCodec> sectionMap, Section s) {
        if (sectionMap.containsKey((Object)s)) {
            return sectionMap.get((Object)s);
        }
        return NULL_CODEC;
    }

    @Override
    public SectionEncoder getSectionEncoderFor(Section s, float version) {
        this.cannotBeNull(s);
        this.verifySupportedVersion(version);
        if (version < 3.0f) {
            return DefaultSectionCodecFactory.getSectionCodecFrom(VERSION_2_MAP, s);
        }
        return DefaultSectionCodecFactory.getSectionCodecFrom(VERSION_3_MAP, s);
    }

    private void verifySupportedVersion(float version) {
        if (version < 2.0f || version >= 4.0f) {
            throw new IllegalArgumentException("can not encode for version < 2 or >= 4");
        }
    }

    private void cannotBeNull(Section s) {
        if (s == null) {
            throw new IllegalArgumentException("Section can not be null");
        }
    }

    static {
        NULL_CODEC = new NullSectionCodec();
        COMMENT_CODEC = new CommentSectionCodec();
        PRIVATE_DATA_CODEC = new PrivateDataCodec();
        VERSION_3_MAP = new EnumMap<Section, SectionCodec>(Section.class);
        VERSION_2_MAP = new EnumMap<Section, SectionCodec>(Section.class);
        VERSION_3_MAP.put(Section.COMMENTS, COMMENT_CODEC);
        VERSION_3_MAP.put(Section.PRIVATE_DATA, PRIVATE_DATA_CODEC);
        VERSION_3_MAP.put(Section.SAMPLES, new Version3SampleSectionCodec());
        VERSION_3_MAP.put(Section.BASES, new Version3BasesSectionCodec());
        VERSION_2_MAP.put(Section.COMMENTS, COMMENT_CODEC);
        VERSION_2_MAP.put(Section.PRIVATE_DATA, PRIVATE_DATA_CODEC);
        VERSION_2_MAP.put(Section.SAMPLES, new Version2SampleSectionCodec());
        VERSION_2_MAP.put(Section.BASES, new Version2BasesSectionCodec());
    }
}

