/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.scf.section;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.trace.chromat.scf.header.SCFHeader;
import org.jcvi.jillion.internal.trace.chromat.scf.section.EncodedSection;
import org.jcvi.jillion.internal.trace.chromat.scf.section.Section;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionDecoderException;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.ChromatogramFileVisitor;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogramBuilder;

public class CommentSectionCodec
implements SectionCodec {
    private static final String NULL = "\u0000";

    @Override
    public long decode(DataInputStream in, long currentOffset, SCFHeader header, ScfChromatogramBuilder c) throws SectionDecoderException {
        long bytesToSkip = Math.max(0L, (long)header.getCommentOffset() - currentOffset);
        try {
            IOUtil.blockingSkip(in, bytesToSkip);
            byte[] comments = new byte[header.getCommentSize()];
            try {
                IOUtil.blockingRead(in, comments, 0, comments.length);
            }
            catch (EOFException e) {
                throw new SectionDecoderException("could not read entire comment section", e);
            }
            Properties props = new Properties();
            props.load(new InputStreamReader((InputStream)new ByteArrayInputStream(comments), IOUtil.UTF_8));
            props.remove(NULL);
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
            c.comments(map);
            return currentOffset + bytesToSkip + (long)comments.length;
        }
        catch (IOException e) {
            throw new SectionDecoderException("error parsing Comment", e);
        }
    }

    @Override
    public EncodedSection encode(Chromatogram c, SCFHeader header) throws IOException {
        Map<String, String> props = c.getComments();
        if (props == null || props.isEmpty()) {
            header.setCommentSize(0);
            return new EncodedSection(null, Section.COMMENTS);
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
        }
        builder.append(NULL);
        ByteBuffer buffer = ByteBuffer.wrap(builder.toString().getBytes(IOUtil.UTF_8));
        header.setCommentSize(builder.length());
        return new EncodedSection(buffer, Section.COMMENTS);
    }

    @Override
    public long decode(DataInputStream in, long currentOffset, SCFHeader header, ChromatogramFileVisitor c) throws SectionDecoderException {
        long bytesToSkip = (long)header.getCommentOffset() - currentOffset;
        try {
            IOUtil.blockingSkip(in, bytesToSkip);
            byte[] comments = new byte[header.getCommentSize()];
            try {
                IOUtil.blockingRead(in, comments, 0, comments.length);
            }
            catch (EOFException e) {
                throw new SectionDecoderException("could not read entire comment section", e);
            }
            Properties props = new Properties();
            props.load(new InputStreamReader((InputStream)new ByteArrayInputStream(comments), IOUtil.UTF_8));
            props.remove(NULL);
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
            c.visitComments(map);
            return currentOffset + bytesToSkip + (long)comments.length;
        }
        catch (IOException e) {
            throw new SectionDecoderException("error parsing Comment", e);
        }
    }
}

