/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.scf.section;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.pos.Position;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.internal.trace.chromat.scf.header.SCFHeader;
import org.jcvi.jillion.internal.trace.chromat.scf.header.pos.PositionStrategy;
import org.jcvi.jillion.internal.trace.chromat.scf.header.pos.PositionStrategyFactory;
import org.jcvi.jillion.internal.trace.chromat.scf.section.EncodedSection;
import org.jcvi.jillion.internal.trace.chromat.scf.section.Section;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionDecoderException;
import org.jcvi.jillion.trace.chromat.ChannelGroup;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.ChromatogramFileVisitor;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogramBuilder;

public abstract class AbstractSampleSectionCodec
implements SectionCodec {
    @Override
    public long decode(DataInputStream in, long currentOffset, SCFHeader header, ScfChromatogramBuilder c) throws SectionDecoderException {
        int numberOfSamples = header.getNumberOfSamples();
        PositionStrategy positionStrategy = PositionStrategyFactory.getPositionStrategy(header);
        long bytesToSkip = Math.max(0L, (long)header.getSampleOffset() - currentOffset);
        try {
            IOUtil.blockingSkip(in, bytesToSkip);
            short[][] positions = this.parseRawPositions(in, numberOfSamples, positionStrategy);
            if (positions != null) {
                this.extractActualPositions(positionStrategy, positions);
                this.setPositions(c, positions);
                return currentOffset + bytesToSkip + (long)(numberOfSamples * header.getSampleSize() * 4);
            }
            return currentOffset + bytesToSkip;
        }
        catch (IOException e) {
            throw new SectionDecoderException("error reading version " + header.getVersion() + " samples", e);
        }
    }

    @Override
    public long decode(DataInputStream in, long currentOffset, SCFHeader header, ChromatogramFileVisitor visitor) throws SectionDecoderException {
        int numberOfSamples = header.getNumberOfSamples();
        PositionStrategy positionStrategy = PositionStrategyFactory.getPositionStrategy(header);
        long bytesToSkip = (long)header.getSampleOffset() - currentOffset;
        try {
            IOUtil.blockingSkip(in, bytesToSkip);
            short[][] positions = this.parseRawPositions(in, numberOfSamples, positionStrategy);
            if (positions != null) {
                this.extractActualPositions(positionStrategy, positions);
                visitor.visitAPositions(positions[0]);
                visitor.visitCPositions(positions[1]);
                visitor.visitGPositions(positions[2]);
                visitor.visitTPositions(positions[3]);
                return currentOffset + bytesToSkip + (long)(numberOfSamples * header.getSampleSize() * 4);
            }
            return currentOffset + bytesToSkip;
        }
        catch (IOException e) {
            throw new SectionDecoderException("error reading version " + header.getVersion() + " samples", e);
        }
    }

    protected abstract void extractActualPositions(PositionStrategy var1, short[][] var2);

    private void setPositions(ScfChromatogramBuilder c, short[][] positions) {
        c.aPositions(positions[0]).cPositions(positions[1]).gPositions(positions[2]).tPositions(positions[3]);
    }

    protected abstract short[][] parseRawPositions(DataInputStream var1, int var2, PositionStrategy var3) throws IOException;

    protected PositionStrategy getPositionStrategyFor(Chromatogram c) {
        return PositionStrategyFactory.getPositionStrategy(this.getMaxPositionsValue(c));
    }

    private int getMaxPositionsValue(Chromatogram c) {
        ChannelGroup group = c.getChannelGroup();
        PositionSequence aPositions = group.getAChannel().getPositionSequence();
        PositionSequence cPositions = group.getCChannel().getPositionSequence();
        PositionSequence gPositions = group.getGChannel().getPositionSequence();
        PositionSequence tPositions = group.getTChannel().getPositionSequence();
        int max = Collections.max(Arrays.asList(this.getMaxValueFor(aPositions), this.getMaxValueFor(cPositions), this.getMaxValueFor(gPositions), this.getMaxValueFor(tPositions)));
        return max;
    }

    private int getMaxValueFor(PositionSequence positions) {
        int currentMax = Integer.MIN_VALUE;
        for (Position position : positions) {
            int value = position.getValue();
            if (value <= currentMax) continue;
            currentMax = value;
        }
        return currentMax;
    }

    @Override
    public EncodedSection encode(Chromatogram c, SCFHeader header) throws IOException {
        PositionStrategy positionStrategy = this.getPositionStrategyFor(c);
        ChannelGroup channelGroup = c.getChannelGroup();
        PositionSequence aPositions = channelGroup.getAChannel().getPositionSequence();
        PositionSequence cPositions = channelGroup.getCChannel().getPositionSequence();
        PositionSequence gPositions = channelGroup.getGChannel().getPositionSequence();
        PositionSequence tPositions = channelGroup.getTChannel().getPositionSequence();
        byte sampleSize = positionStrategy.getSampleSize();
        int numberOfSamples = (int)aPositions.getLength();
        int bufferLength = numberOfSamples * 4 * sampleSize;
        ByteBuffer buffer = ByteBuffer.allocate(bufferLength);
        this.writePositionsToBuffer(positionStrategy, aPositions, cPositions, gPositions, tPositions, buffer);
        buffer.flip();
        header.setNumberOfSamples(numberOfSamples);
        header.setSampleSize(sampleSize);
        return new EncodedSection(buffer, Section.SAMPLES);
    }

    protected abstract void writePositionsToBuffer(PositionStrategy var1, PositionSequence var2, PositionSequence var3, PositionSequence var4, PositionSequence var5, ByteBuffer var6);
}

