/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.scf.section;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.trace.chromat.scf.header.SCFHeader;
import org.jcvi.jillion.internal.trace.chromat.scf.section.EncodedSection;
import org.jcvi.jillion.internal.trace.chromat.scf.section.Section;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionDecoderException;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.ChromatogramFileVisitor;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogramBuilder;

public abstract class AbstractBasesSectionCodec
implements SectionCodec {
    @Override
    public long decode(DataInputStream in, long currentOffset, SCFHeader header, ScfChromatogramBuilder c) throws SectionDecoderException {
        long bytesToSkip = Math.max(0L, (long)header.getBasesOffset() - currentOffset);
        int numberOfBases = header.getNumberOfBases();
        try {
            IOUtil.blockingSkip(in, bytesToSkip);
            this.readBasesData(in, c, numberOfBases);
            return currentOffset + bytesToSkip + (long)(numberOfBases * 12);
        }
        catch (IOException e) {
            throw new SectionDecoderException("error reading bases section", e);
        }
    }

    @Override
    public long decode(DataInputStream in, long currentOffset, SCFHeader header, ChromatogramFileVisitor visitor) throws SectionDecoderException {
        long bytesToSkip = (long)header.getBasesOffset() - currentOffset;
        int numberOfBases = header.getNumberOfBases();
        try {
            IOUtil.blockingSkip(in, bytesToSkip);
            this.readBasesData(in, visitor, numberOfBases);
            return currentOffset + bytesToSkip + (long)(numberOfBases * 12);
        }
        catch (IOException e) {
            throw new SectionDecoderException("error reading bases section", e);
        }
    }

    protected abstract void readBasesData(DataInputStream var1, ScfChromatogramBuilder var2, int var3) throws IOException;

    protected abstract void readBasesData(DataInputStream var1, ChromatogramFileVisitor var2, int var3) throws IOException;

    protected static ScfChromatogramBuilder setConfidences(ScfChromatogramBuilder c, byte[][] probability) {
        return c.aQualities(probability[0]).cQualities(probability[1]).gQualities(probability[2]).tQualities(probability[3]);
    }

    @Override
    public EncodedSection encode(Chromatogram c, SCFHeader header) throws IOException {
        int numberOfBases = (int)c.getNucleotideSequence().getLength();
        header.setNumberOfBases(numberOfBases);
        ByteBuffer buffer = ByteBuffer.allocate(numberOfBases * 12);
        this.writeBasesDataToBuffer(buffer, c, numberOfBases);
        buffer.flip();
        return new EncodedSection(buffer, Section.BASES);
    }

    protected abstract void writeBasesDataToBuffer(ByteBuffer var1, Chromatogram var2, int var3);
}

