/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.scf.header.pos;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jcvi.jillion.internal.trace.chromat.scf.header.SCFHeader;
import org.jcvi.jillion.internal.trace.chromat.scf.header.pos.BytePositionStrategy;
import org.jcvi.jillion.internal.trace.chromat.scf.header.pos.PositionStrategy;
import org.jcvi.jillion.internal.trace.chromat.scf.header.pos.ShortPositionStrategy;

public final class PositionStrategyFactory {
    private static final PositionStrategy SHORT_STRATEGY = new ShortPositionStrategy();
    private static final PositionStrategy BYTE_STRATEGY = new BytePositionStrategy();
    private static Map<Integer, PositionStrategy> MAX_SIZE_MAP = new TreeMap<Integer, PositionStrategy>();
    private static Map<Byte, PositionStrategy> SAMPLE_SIZE_MAP;

    private PositionStrategyFactory() {
    }

    public static PositionStrategy getPositionStrategy(SCFHeader header) {
        byte sampleSize = header.getSampleSize();
        PositionStrategy ret = SAMPLE_SIZE_MAP.get(sampleSize);
        if (ret == null) {
            throw new IllegalArgumentException("no Position Strategy implementation available for sample size " + sampleSize);
        }
        return ret;
    }

    public static PositionStrategy getPositionStrategy(int maxValue) {
        for (Map.Entry<Integer, PositionStrategy> entry : MAX_SIZE_MAP.entrySet()) {
            if (maxValue > entry.getKey()) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("no Position Strategy implementation available for max value " + maxValue);
    }

    static {
        MAX_SIZE_MAP.put(BYTE_STRATEGY.getMaxAllowedValue(), BYTE_STRATEGY);
        MAX_SIZE_MAP.put(SHORT_STRATEGY.getMaxAllowedValue(), SHORT_STRATEGY);
        SAMPLE_SIZE_MAP = new HashMap<Byte, PositionStrategy>();
        SAMPLE_SIZE_MAP.put(BYTE_STRATEGY.getSampleSize(), BYTE_STRATEGY);
        SAMPLE_SIZE_MAP.put(SHORT_STRATEGY.getSampleSize(), SHORT_STRATEGY);
    }
}

