/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.scf.header;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.trace.chromat.scf.SCFUtils;
import org.jcvi.jillion.internal.trace.chromat.scf.header.DefaultSCFHeader;
import org.jcvi.jillion.internal.trace.chromat.scf.header.SCFHeader;
import org.jcvi.jillion.internal.trace.chromat.scf.header.SCFHeaderCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.header.SCFHeaderDecoderException;

public enum DefaultSCFHeaderCodec implements SCFHeaderCodec
{
    INSTANCE;

    private static final byte LENGTH_OF_SPARE = 72;
    private static final byte LENGTH_OF_BASE_CLIP_DATA = 8;

    @Override
    public SCFHeader decode(DataInputStream in) throws SCFHeaderDecoderException {
        if (in == null) {
            throw new IllegalArgumentException("input stream can not be null");
        }
        try {
            this.verifyMagicNumber(in);
            return this.parseSCFHeader(in);
        }
        catch (IOException e) {
            throw new SCFHeaderDecoderException("Error parsing Header", e);
        }
    }

    private SCFHeader parseSCFHeader(DataInputStream in) throws IOException {
        DefaultSCFHeader header = new DefaultSCFHeader();
        header.setNumberOfSamples(in.readInt());
        header.setSampleOffset(in.readInt());
        header.setNumberOfBases(in.readInt());
        this.skipBaseClipData(in);
        header.setBasesOffset(in.readInt());
        header.setCommentSize(in.readInt());
        header.setCommentOffset(in.readInt());
        header.setVersion(this.parseVersion(in));
        header.setSampleSize((byte)in.readInt());
        this.skipUncertaintyCode(in);
        header.setPrivateDataSize(in.readInt());
        header.setPrivateDataOffset(in.readInt());
        this.skipSpare(in);
        return header;
    }

    private void skipUncertaintyCode(DataInputStream in) throws IOException {
        in.readInt();
    }

    private void verifyMagicNumber(DataInputStream in) throws IOException, SCFHeaderDecoderException {
        byte[] actualMagicNumber = new byte[4];
        int bytesRead = in.read(actualMagicNumber);
        if (bytesRead != actualMagicNumber.length) {
            throw new SCFHeaderDecoderException("File does not have magic number");
        }
        if (!SCFUtils.isMagicNumber(actualMagicNumber)) {
            throw new SCFHeaderDecoderException("Magic number " + new String(actualMagicNumber, IOUtil.UTF_8) + " does not match expected");
        }
    }

    private void skipSpare(DataInputStream in) throws IOException {
        IOUtil.blockingSkip(in, 72L);
    }

    private float parseVersion(DataInputStream in) throws IOException {
        byte[] version = new byte[4];
        int bytesRead = in.read(version);
        if (bytesRead != version.length) {
            throw new IOException("Stream truncated mid version");
        }
        try {
            return Float.parseFloat(new String(version, IOUtil.UTF_8));
        }
        catch (NumberFormatException e) {
            throw new IOException("could not parse version" + Arrays.toString(version), e);
        }
    }

    private void skipBaseClipData(DataInputStream in) throws IOException {
        IOUtil.blockingSkip(in, 8L);
    }

    @Override
    public ByteBuffer encode(SCFHeader header) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[128]);
        buffer.put(SCFUtils.getMagicNumber());
        buffer.putInt(header.getNumberOfSamples());
        buffer.putInt(header.getSampleOffset());
        buffer.putInt(header.getNumberOfBases());
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.putInt(header.getBasesOffset());
        buffer.putInt(header.getCommentSize());
        buffer.putInt(header.getCommentOffset());
        buffer.put(String.format("%1.2f", Float.valueOf(header.getVersion())).getBytes(IOUtil.UTF_8));
        buffer.putInt(header.getSampleSize());
        buffer.putInt(0);
        buffer.putInt(header.getPrivateDataSize());
        buffer.putInt(header.getPrivateDataOffset());
        buffer.rewind();
        return buffer;
    }
}

