/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.scf;

import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.util.ObjectsUtil;
import org.jcvi.jillion.internal.trace.chromat.BasicChromatogram;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.scf.PrivateData;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogram;

public class ScfChromatogramImpl
extends BasicChromatogram
implements ScfChromatogram {
    private PrivateData privateData;
    private QualitySequence substitutionConfidence;
    private QualitySequence insertionConfidence;
    private QualitySequence deletionConfidence;

    public ScfChromatogramImpl(Chromatogram c) {
        this(c, null, null, null, null);
    }

    public ScfChromatogramImpl(Chromatogram c, QualitySequence subtitutionConfidence, QualitySequence insertionConfidence, QualitySequence deletConfidence, PrivateData privateData) {
        super(c);
        this.substitutionConfidence = subtitutionConfidence;
        this.deletionConfidence = deletConfidence;
        this.insertionConfidence = insertionConfidence;
        this.privateData = privateData;
    }

    @Override
    public PrivateData getPrivateData() {
        return this.privateData;
    }

    @Override
    public QualitySequence getSubstitutionConfidence() {
        return this.substitutionConfidence;
    }

    @Override
    public QualitySequence getInsertionConfidence() {
        return this.insertionConfidence;
    }

    @Override
    public QualitySequence getDeletionConfidence() {
        return this.deletionConfidence;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + ObjectsUtil.nullSafeHashCode(this.deletionConfidence);
        result = 31 * result + ObjectsUtil.nullSafeHashCode(this.insertionConfidence);
        result = 31 * result + ObjectsUtil.nullSafeHashCode(this.privateData);
        result = 31 * result + ObjectsUtil.nullSafeHashCode(this.substitutionConfidence);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ScfChromatogram)) {
            return false;
        }
        ScfChromatogram other = (ScfChromatogram)obj;
        return ObjectsUtil.nullSafeEquals(this.getDeletionConfidence(), other.getDeletionConfidence()) && ObjectsUtil.nullSafeEquals(this.getInsertionConfidence(), other.getInsertionConfidence()) && ObjectsUtil.nullSafeEquals(this.getSubstitutionConfidence(), other.getSubstitutionConfidence()) && ObjectsUtil.nullSafeEquals(this.getPrivateData(), other.getPrivateData());
    }
}

