/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.scf;

import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.List;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.pos.Position;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.internal.trace.chromat.scf.section.Section;

public final class SCFUtils {
    public static final int HEADER_SIZE = 128;
    public static final List<Section> ORDER_OF_SECTIONS = Arrays.asList(Section.SAMPLES, Section.BASES, Section.COMMENTS, Section.PRIVATE_DATA);
    private static final byte[] MAGIC_NUMBER = new byte[]{46, 115, 99, 102};

    private SCFUtils() {
    }

    public static final byte[] getMagicNumber() {
        byte[] ret = new byte[MAGIC_NUMBER.length];
        System.arraycopy(MAGIC_NUMBER, 0, ret, 0, ret.length);
        return ret;
    }

    public static boolean isMagicNumber(byte[] magicNumber) {
        return Arrays.equals(MAGIC_NUMBER, magicNumber);
    }

    public static void deltaDeltaDecode(short[] positions) {
        positions[1] = (short)(positions[1] + 2 * positions[0]);
        for (int i = 2; i < positions.length; ++i) {
            int n = i;
            positions[n] = (short)(positions[n] + (short)(2 * positions[i - 1] - positions[i - 2]));
        }
    }

    public static ShortBuffer deltaDeltaEncode(ShortBuffer original) {
        ShortBuffer buffer = SCFUtils.copy(original);
        for (int i = buffer.limit() - 1; i > 1; --i) {
            short deltaDelta = (short)(buffer.get(i) - 2 * buffer.get(i - 1) + buffer.get(i - 2));
            buffer.put(i, deltaDelta);
        }
        buffer.put(1, (short)(buffer.get(1) - 2 * buffer.get(0)));
        return (ShortBuffer)buffer.rewind();
    }

    public static ShortBuffer deltaDeltaEncode(PositionSequence original) {
        ShortBuffer buffer = ShortBuffer.allocate((int)original.getLength());
        for (Position pos : original) {
            buffer.put(IOUtil.toSignedShort(pos.getValue()));
        }
        buffer.rewind();
        return SCFUtils.deltaDeltaEncode(buffer);
    }

    public static short[] deltaDeltaEncode(short[] original) {
        return SCFUtils.deltaDeltaEncode(ShortBuffer.wrap(original)).array();
    }

    public static ShortBuffer copy(ShortBuffer original) {
        ShortBuffer aCopy = ShortBuffer.allocate(original.remaining());
        aCopy.put(original);
        return (ShortBuffer)aCopy.rewind();
    }
}

