/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.scf;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.trace.chromat.scf.SCFCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.SCFUtils;
import org.jcvi.jillion.internal.trace.chromat.scf.header.DefaultSCFHeader;
import org.jcvi.jillion.internal.trace.chromat.scf.header.DefaultSCFHeaderCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.header.SCFHeader;
import org.jcvi.jillion.internal.trace.chromat.scf.header.SCFHeaderCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.section.DefaultSectionCodecFactory;
import org.jcvi.jillion.internal.trace.chromat.scf.section.EncodedSection;
import org.jcvi.jillion.internal.trace.chromat.scf.section.Section;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionCodecFactory;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionDecoder;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionDecoderException;
import org.jcvi.jillion.internal.trace.chromat.scf.section.SectionEncoder;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.ChromatogramFileVisitor;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogram;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogramBuilder;
import org.jcvi.jillion.trace.chromat.scf.ScfDecoderException;

public enum SCFCodecs implements SCFCodec
{
    VERSION_3{

        @Override
        public void encode(Chromatogram c, OutputStream out) throws IOException {
            this.encode(out, c, 3);
        }
    }
    ,
    VERSION_2{

        @Override
        public void encode(Chromatogram c, OutputStream out) throws IOException {
            this.encode(out, c, 2);
        }
    };

    private SectionCodecFactory sectionCodecFactory;
    private SCFHeaderCodec headerCodec = DefaultSCFHeaderCodec.INSTANCE;

    private SCFCodecs() {
        this.sectionCodecFactory = DefaultSectionCodecFactory.INSTANCE;
    }

    private ScfChromatogram decode(String id, InputStream in) throws ScfDecoderException {
        DataInputStream dataIn = new DataInputStream(in);
        SCFHeader header = this.headerCodec.decode(dataIn);
        ScfChromatogramBuilder builder = new ScfChromatogramBuilder(id);
        SortedMap<Integer, Section> sectionsByOffset = SCFCodecs.createSectionsByOffsetMap(header);
        long currentOffset = 128L;
        for (Map.Entry<Integer, Section> entry : sectionsByOffset.entrySet()) {
            SectionDecoder sp = this.sectionCodecFactory.getSectionParserFor(entry.getValue(), header);
            currentOffset = sp.decode(dataIn, currentOffset, header, builder);
        }
        return builder.build();
    }

    public void parse(DataInputStream dataIn, SCFHeader header, ChromatogramFileVisitor visitor) throws SectionDecoderException {
        SortedMap<Integer, Section> sectionsByOffset = SCFCodecs.createSectionsByOffsetMap(header);
        long currentOffset = 128L;
        for (Map.Entry<Integer, Section> entry : sectionsByOffset.entrySet()) {
            SectionDecoder sp = this.sectionCodecFactory.getSectionParserFor(entry.getValue(), header);
            currentOffset = sp.decode(dataIn, currentOffset, header, visitor);
        }
        visitor.visitEnd();
    }

    @Override
    public void parse(InputStream in, ChromatogramFileVisitor visitor) throws ScfDecoderException {
        DataInputStream dataIn = new DataInputStream(in);
        SCFHeader header = this.headerCodec.decode(dataIn);
        this.parse(dataIn, header, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(File scfFile, ChromatogramFileVisitor visitor) throws ScfDecoderException, FileNotFoundException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(scfFile);
            this.parse(in, visitor);
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(in);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScfChromatogram decode(File sangerTrace) throws IOException, FileNotFoundException {
        ScfChromatogram scfChromatogram;
        FileInputStream in = null;
        try {
            in = new FileInputStream(sangerTrace);
            scfChromatogram = this.decode(sangerTrace.getName(), in);
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(in);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)in);
        return scfChromatogram;
    }

    private static SortedMap<Integer, Section> createSectionsByOffsetMap(SCFHeader header) {
        TreeMap<Integer, Section> sectionsByOffset = new TreeMap<Integer, Section>();
        sectionsByOffset.put(header.getBasesOffset(), Section.BASES);
        sectionsByOffset.put(header.getSampleOffset(), Section.SAMPLES);
        sectionsByOffset.put(header.getCommentOffset(), Section.COMMENTS);
        sectionsByOffset.put(header.getPrivateDataOffset(), Section.PRIVATE_DATA);
        return sectionsByOffset;
    }

    @Override
    public void write(Chromatogram chromatogram, OutputStream out) throws IOException {
        this.encode(chromatogram, out);
    }

    protected abstract void encode(Chromatogram var1, OutputStream var2) throws IOException;

    protected final void encode(OutputStream out, Chromatogram c, int version) throws IOException {
        DefaultSCFHeader header = new DefaultSCFHeader();
        header.setVersion(version);
        int currentOffset = 128;
        EnumMap<Section, EncodedSection> encodedSectionMap = new EnumMap<Section, EncodedSection>(Section.class);
        for (Section s : SCFUtils.ORDER_OF_SECTIONS) {
            SCFCodecs.setOffsetFor(s, currentOffset, header);
            SectionEncoder encoder = this.sectionCodecFactory.getSectionEncoderFor(s, version);
            EncodedSection encodedSection = encoder.encode(c, header);
            encodedSectionMap.put(s, encodedSection);
            ByteBuffer data = encodedSection.getData();
            if (data == null) continue;
            currentOffset += data.limit();
        }
        ByteBuffer result = ByteBuffer.allocate(currentOffset);
        result.put(this.headerCodec.encode(header));
        for (Section s : SCFUtils.ORDER_OF_SECTIONS) {
            ByteBuffer data = ((EncodedSection)encodedSectionMap.get((Object)s)).getData();
            if (data == null) continue;
            result.put(data);
        }
        result.rewind();
        out.write(result.array());
    }

    private static void setOffsetFor(Section s, int currentOffset, SCFHeader header) {
        if (s == Section.SAMPLES) {
            header.setSampleOffset(currentOffset);
        } else if (s == Section.BASES) {
            header.setBasesOffset(currentOffset);
        } else if (s == Section.COMMENTS) {
            header.setCommentOffset(currentOffset);
        } else if (s == Section.PRIVATE_DATA) {
            header.setPrivateDataOffset(currentOffset);
        }
    }
}

