/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.abi.tag.rate;

import org.jcvi.jillion.trace.chromat.abi.tag.rate.ScanRate;

final class DefaultScanRate
implements ScanRate {
    private final int time;
    private final int period;
    private final int line;

    private DefaultScanRate(int time, int period, int line) {
        this.time = time;
        this.period = period;
        this.line = line;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public int getScanPeriod() {
        return this.period;
    }

    @Override
    public int getFirstScanLine() {
        return this.line;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.line;
        result = 31 * result + this.period;
        result = 31 * result + this.time;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanRate)) {
            return false;
        }
        ScanRate other = (ScanRate)obj;
        if (this.line != other.getFirstScanLine()) {
            return false;
        }
        if (this.period != other.getScanPeriod()) {
            return false;
        }
        return this.time == other.getTime();
    }

    public String toString() {
        return "DefaultScanRate [time=" + this.time + ", period=" + this.period + ", line=" + this.line + "]";
    }

    public static final class Builder
    implements org.jcvi.jillion.core.util.Builder<DefaultScanRate> {
        private int time;
        private int line;
        private int period;

        public Builder time(int time) {
            this.time = time;
            return this;
        }

        public Builder firstScanLine(int line) {
            this.line = line;
            return this;
        }

        public Builder period(int period) {
            this.period = period;
            return this;
        }

        @Override
        public DefaultScanRate build() {
            return new DefaultScanRate(this.time, this.period, this.line);
        }
    }
}

