/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.abi.tag;

import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.DefaultAsciiTaggedDataRecord;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.DefaultDateTaggedDataRecord;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.DefaultFloatTaggedDataRecord;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.DefaultIntegerArrayTaggedDataRecord;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.DefaultPascalStringTaggedDataRecord;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.DefaultShortArrayTaggedDataRecord;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.DefaultTaggedDataRecord;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.DefaultTimeTaggedDataRecord;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.DefaultUserDefinedTaggedDataRecord;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.rate.DefaultScanRateTaggedDataType;
import org.jcvi.jillion.trace.chromat.abi.tag.TaggedDataName;
import org.jcvi.jillion.trace.chromat.abi.tag.TaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.TaggedDataType;

public class TaggedDataRecordBuilder
implements Builder<TaggedDataRecord<?, ?>> {
    private final TaggedDataName name;
    private final long number;
    private TaggedDataType dataType;
    private int elementLength;
    private long numberOfElements;
    private long recordLength;
    private long dataRecord;
    private long crypticValue;

    public TaggedDataRecordBuilder(TaggedDataName name, long number) {
        if (name == null) {
            throw new NullPointerException("name can not be null");
        }
        if (number < 0L) {
            throw new IllegalArgumentException("tag number must be >=0");
        }
        this.name = name;
        this.number = number;
    }

    public TaggedDataRecordBuilder setDataType(TaggedDataType dataType, int elementLength) {
        if (dataType == null) {
            throw new NullPointerException("dataType can not be null");
        }
        if (elementLength < 1) {
            throw new IllegalArgumentException("elementLength must be >0");
        }
        this.dataType = dataType;
        this.elementLength = elementLength;
        return this;
    }

    public TaggedDataRecordBuilder setRecordLength(long recordLength) {
        if (recordLength < 1L) {
            throw new IllegalArgumentException("recordLength must be >0");
        }
        this.recordLength = recordLength;
        return this;
    }

    public TaggedDataRecordBuilder setNumberOfElements(long numberOfElements) {
        if (numberOfElements < 1L) {
            throw new IllegalArgumentException("numberOfElements must be >0");
        }
        this.numberOfElements = numberOfElements;
        return this;
    }

    public TaggedDataRecordBuilder setDataRecord(long dataRecord) {
        this.dataRecord = dataRecord;
        return this;
    }

    public TaggedDataRecordBuilder setCrypticValue(long crypticValue) {
        this.crypticValue = crypticValue;
        return this;
    }

    @Override
    public TaggedDataRecord<?, ?> build() {
        if (this.numberOfElements * (long)this.elementLength != this.recordLength) {
            throw new IllegalStateException(String.format("invalid record length: expected(%d) but was %d", this.recordLength, this.numberOfElements * (long)this.elementLength));
        }
        switch (this.dataType) {
            case FLOAT: {
                return new DefaultFloatTaggedDataRecord(this.name, this.number, this.dataType, this.elementLength, this.numberOfElements, this.recordLength, this.dataRecord, this.crypticValue);
            }
            case PASCAL_STRING: {
                return new DefaultPascalStringTaggedDataRecord(this.name, this.number, this.dataType, this.elementLength, this.numberOfElements, this.recordLength, this.dataRecord, this.crypticValue);
            }
            case TIME: {
                return new DefaultTimeTaggedDataRecord(this.name, this.number, this.dataType, this.elementLength, this.numberOfElements, this.recordLength, this.dataRecord, this.crypticValue);
            }
            case DATE: {
                return new DefaultDateTaggedDataRecord(this.name, this.number, this.dataType, this.elementLength, this.numberOfElements, this.recordLength, this.dataRecord, this.crypticValue);
            }
            case INTEGER: {
                return this.handleNumberCase();
            }
            case USER_DEFINED: {
                return this.handleUserDefinedCase();
            }
        }
        return this.handleDefaultCase();
    }

    private TaggedDataRecord<?, ?> handleNumberCase() {
        if (this.elementLength == 2) {
            return new DefaultShortArrayTaggedDataRecord(this.name, this.number, this.dataType, this.elementLength, this.numberOfElements, this.recordLength, this.dataRecord, this.crypticValue);
        }
        return new DefaultIntegerArrayTaggedDataRecord(this.name, this.number, this.dataType, this.elementLength, this.numberOfElements, this.recordLength, this.dataRecord, this.crypticValue);
    }

    private TaggedDataRecord<?, ?> handleUserDefinedCase() {
        if (this.name == TaggedDataName.Rate) {
            return new DefaultScanRateTaggedDataType(this.name, this.number, this.dataType, this.elementLength, this.numberOfElements, this.recordLength, this.dataRecord, this.crypticValue);
        }
        return new DefaultUserDefinedTaggedDataRecord(this.name, this.number, this.dataType, this.elementLength, this.numberOfElements, this.recordLength, this.dataRecord, this.crypticValue);
    }

    private TaggedDataRecord<?, ?> handleDefaultCase() {
        if (this.name.usesNullTerminatedStringValues()) {
            return new DefaultAsciiTaggedDataRecord(this.name, this.number, this.dataType, this.elementLength, this.numberOfElements, this.recordLength, this.dataRecord, this.crypticValue);
        }
        return new DefaultTaggedDataRecord(this.name, this.number, this.dataType, this.elementLength, this.numberOfElements, this.recordLength, this.dataRecord, this.crypticValue);
    }
}

