/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.abi.tag;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.AbstractTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.FloatArrayTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.TaggedDataName;
import org.jcvi.jillion.trace.chromat.abi.tag.TaggedDataType;

public class DefaultFloatTaggedDataRecord
extends AbstractTaggedDataRecord<FloatArrayTaggedDataRecord, float[]>
implements FloatArrayTaggedDataRecord {
    public DefaultFloatTaggedDataRecord(TaggedDataName name, long number, TaggedDataType dataType, int elementLength, long numberOfElements, long recordLength, long dataRecord, long crypticValue) {
        super(name, number, dataType, elementLength, numberOfElements, recordLength, dataRecord, crypticValue);
    }

    @Override
    protected float[] parseDataFrom(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        FloatBuffer result = FloatBuffer.allocate(data.length / 4);
        while (buffer.hasRemaining()) {
            result.put(buffer.getFloat());
        }
        return result.array();
    }

    @Override
    public Class<float[]> getParsedDataType() {
        return float[].class;
    }

    @Override
    public Class<FloatArrayTaggedDataRecord> getType() {
        return FloatArrayTaggedDataRecord.class;
    }
}

