/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.abi.tag;

import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.trace.chromat.abi.tag.TaggedDataName;
import org.jcvi.jillion.trace.chromat.abi.tag.TaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.TaggedDataType;

public abstract class AbstractTaggedDataRecord<T, D>
implements TaggedDataRecord<T, D> {
    private final TaggedDataName name;
    private final long tagNumber;
    private final TaggedDataType dataType;
    private final int elementLength;
    private final long numberOfElements;
    private final long recordLength;
    private final long dataRecord;
    private final long crypticValue;

    public AbstractTaggedDataRecord(TaggedDataName name, long number, TaggedDataType dataType, int elementLength, long numberOfElements, long recordLength, long dataRecord, long crypticValue) {
        this.name = name;
        this.tagNumber = number;
        this.dataType = dataType;
        this.elementLength = elementLength;
        this.numberOfElements = numberOfElements;
        this.recordLength = recordLength;
        this.dataRecord = dataRecord;
        this.crypticValue = crypticValue;
    }

    @Override
    public long getCrypticValue() {
        return this.crypticValue;
    }

    @Override
    public long getDataRecord() {
        return this.dataRecord;
    }

    @Override
    public TaggedDataType getDataType() {
        return this.dataType;
    }

    @Override
    public int getElementLength() {
        return this.elementLength;
    }

    @Override
    public TaggedDataName getTagName() {
        return this.name;
    }

    @Override
    public long getTagNumber() {
        return this.tagNumber;
    }

    @Override
    public long getNumberOfElements() {
        return this.numberOfElements;
    }

    @Override
    public long getRecordLength() {
        return this.recordLength;
    }

    @Override
    public D parseDataRecordFrom(byte[] ab1DataBlock) {
        if (this.recordLength < 5L) {
            return this.parseDataFrom(IOUtil.convertUnsignedIntToByteArray(this.dataRecord));
        }
        byte[] data = new byte[(int)this.recordLength];
        System.arraycopy(ab1DataBlock, (int)(this.dataRecord - 30L), data, 0, data.length);
        return this.parseDataFrom(data);
    }

    protected abstract D parseDataFrom(byte[] var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.crypticValue ^ this.crypticValue >>> 32);
        result = 31 * result + (int)(this.dataRecord ^ this.dataRecord >>> 32);
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + this.elementLength;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (int)(this.tagNumber ^ this.tagNumber >>> 32);
        result = 31 * result + (int)(this.numberOfElements ^ this.numberOfElements >>> 32);
        result = 31 * result + (int)(this.recordLength ^ this.recordLength >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaggedDataRecord)) {
            return false;
        }
        TaggedDataRecord other = (TaggedDataRecord)obj;
        if (!this.name.equals((Object)other.getTagName())) {
            return false;
        }
        if (this.tagNumber != other.getTagNumber()) {
            return false;
        }
        if (!this.dataType.equals((Object)other.getDataType())) {
            return false;
        }
        if (this.elementLength != other.getElementLength()) {
            return false;
        }
        if (this.numberOfElements != other.getNumberOfElements()) {
            return false;
        }
        if (this.recordLength != other.getRecordLength()) {
            return false;
        }
        if (this.dataRecord != other.getDataRecord()) {
            return false;
        }
        return this.crypticValue == other.getCrypticValue();
    }

    public String toString() {
        return String.format("%s[%s(%d) %d]", new Object[]{this.getClass().getName(), this.name, this.tagNumber, this.dataRecord});
    }
}

