/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat.abi;

import java.util.Arrays;
import org.jcvi.jillion.core.io.IOUtil;

public final class AbiUtil {
    private static final byte[] MAGIC_NUMBER = new byte[]{65, 66, 73, 70};
    public static final int HEADER_SIZE = 30;

    private AbiUtil() {
    }

    public static byte[] getMagicNumber() {
        byte[] ret = new byte[MAGIC_NUMBER.length];
        System.arraycopy(MAGIC_NUMBER, 0, ret, 0, ret.length);
        return ret;
    }

    public static String parseASCIIStringFrom(byte[] data) {
        return new String(data, IOUtil.UTF_8);
    }

    public static String parsePascalStringFrom(byte[] data) {
        return new String(data, 1, data.length - 1, IOUtil.UTF_8);
    }

    public static boolean isABIMagicNumber(byte[] magicNumber) {
        return Arrays.equals(MAGIC_NUMBER, magicNumber);
    }
}

