/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat;

import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.util.ObjectsUtil;
import org.jcvi.jillion.trace.chromat.Channel;
import org.jcvi.jillion.trace.chromat.ChannelGroup;

public class DefaultChannelGroup
implements ChannelGroup {
    private final Channel aChannel;
    private final Channel cChannel;
    private final Channel gChannel;
    private final Channel tChannel;

    public DefaultChannelGroup(Channel aChannel, Channel cChannel, Channel gChannel, Channel tChannel) {
        this.aChannel = aChannel;
        this.cChannel = cChannel;
        this.gChannel = gChannel;
        this.tChannel = tChannel;
        this.validate();
    }

    private void validate() {
        this.channelsCannotBeNull();
        this.confidencesMustHaveSameLength();
        this.positionsMustHaveSameLength();
    }

    private void channelsCannotBeNull() {
        String errorMessage = "channels can not be null";
        ObjectsUtil.checkNotNull(this.aChannel, errorMessage);
        ObjectsUtil.checkNotNull(this.cChannel, errorMessage);
        ObjectsUtil.checkNotNull(this.gChannel, errorMessage);
        ObjectsUtil.checkNotNull(this.tChannel, errorMessage);
    }

    private void positionsMustHaveSameLength() {
        long posLength = this.aChannel.getPositionSequence().getLength();
        if (posLength != this.cChannel.getPositionSequence().getLength() || posLength != this.gChannel.getPositionSequence().getLength() || posLength != this.tChannel.getPositionSequence().getLength()) {
            throw new IllegalArgumentException("positions must all have the same length");
        }
    }

    private void confidencesMustHaveSameLength() {
        long confidenceLength = this.aChannel.getQualitySequence().getLength();
        if (confidenceLength != this.cChannel.getQualitySequence().getLength() || confidenceLength != this.gChannel.getQualitySequence().getLength() || confidenceLength != this.tChannel.getQualitySequence().getLength()) {
            throw new IllegalArgumentException("confidences must all have the same length");
        }
    }

    @Override
    public Channel getAChannel() {
        return this.aChannel;
    }

    @Override
    public Channel getCChannel() {
        return this.cChannel;
    }

    @Override
    public Channel getGChannel() {
        return this.gChannel;
    }

    @Override
    public Channel getTChannel() {
        return this.tChannel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.aChannel.hashCode();
        result = 31 * result + this.cChannel.hashCode();
        result = 31 * result + this.gChannel.hashCode();
        result = 31 * result + this.tChannel.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultChannelGroup)) {
            return false;
        }
        ChannelGroup other = (ChannelGroup)obj;
        return ObjectsUtil.nullSafeEquals(this.getAChannel(), other.getAChannel()) && ObjectsUtil.nullSafeEquals(this.getCChannel(), other.getCChannel()) && ObjectsUtil.nullSafeEquals(this.getGChannel(), other.getGChannel()) && ObjectsUtil.nullSafeEquals(this.getTChannel(), other.getTChannel());
    }

    @Override
    public Channel getChannel(Nucleotide channelToGet) {
        if (channelToGet == null) {
            throw new NullPointerException("channel to get can not be null");
        }
        if (channelToGet == Nucleotide.Adenine) {
            return this.getAChannel();
        }
        if (channelToGet == Nucleotide.Cytosine) {
            return this.getCChannel();
        }
        if (channelToGet == Nucleotide.Guanine) {
            return this.getGChannel();
        }
        return this.getTChannel();
    }
}

