/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat;

import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.pos.PositionSequenceBuilder;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.util.ObjectsUtil;
import org.jcvi.jillion.trace.chromat.Channel;

public final class DefaultChannel
implements Channel {
    private final QualitySequence confidence;
    private final PositionSequence positions;

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultChannel)) {
            return false;
        }
        Channel other = (Channel)obj;
        return ObjectsUtil.nullSafeEquals(this.getQualitySequence(), other.getQualitySequence()) && ObjectsUtil.nullSafeEquals(this.getPositionSequence(), other.getPositionSequence());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getQualitySequence() == null ? 0 : this.getQualitySequence().hashCode());
        result = 31 * result + (this.getPositionSequence() == null ? 0 : this.getPositionSequence().hashCode());
        return result;
    }

    public DefaultChannel(byte[] qualities, short[] positions) {
        this(new QualitySequenceBuilder(qualities).build(), new PositionSequenceBuilder(positions).build());
    }

    public DefaultChannel(QualitySequence qualities, PositionSequence positions) {
        if (qualities == null) {
            throw new NullPointerException("qualities can not be null");
        }
        if (positions == null) {
            throw new NullPointerException("positions can not be null");
        }
        this.confidence = qualities;
        this.positions = positions;
    }

    @Override
    public QualitySequence getQualitySequence() {
        return this.confidence;
    }

    @Override
    public PositionSequence getPositionSequence() {
        return this.positions;
    }
}

