/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.core.io.MagicNumberInputStream;
import org.jcvi.jillion.internal.trace.chromat.abi.AbiUtil;
import org.jcvi.jillion.internal.trace.chromat.scf.SCFUtils;
import org.jcvi.jillion.internal.trace.chromat.ztr.ZTRUtil;

public final class ChromatogramUtil {
    private ChromatogramUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isChromatogram(File f) throws IOException {
        boolean bl;
        MagicNumberInputStream in = null;
        try {
            in = new MagicNumberInputStream(new BufferedInputStream(new FileInputStream(f)));
            byte[] magicNumber = in.peekMagicNumber();
            bl = ChromatogramUtil.isChromatogram(magicNumber);
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(in);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)in);
        return bl;
    }

    private static boolean isChromatogram(byte[] magicNumber) {
        return AbiUtil.isABIMagicNumber(magicNumber) || ZTRUtil.isMagicNumber(magicNumber) || SCFUtils.isMagicNumber(magicNumber);
    }
}

