/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.internal.trace.chromat.BasicChromatogram;
import org.jcvi.jillion.internal.trace.chromat.DefaultChannel;
import org.jcvi.jillion.internal.trace.chromat.DefaultChannelGroup;
import org.jcvi.jillion.trace.chromat.ChannelGroup;
import org.jcvi.jillion.trace.chromat.Chromatogram;

public final class BasicChromatogramBuilder {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private PositionSequence peaks;
    private NucleotideSequence basecalls;
    private byte[] aQualities = EMPTY_BYTE_ARRAY;
    private byte[] cQualities = EMPTY_BYTE_ARRAY;
    private byte[] gConfidence = EMPTY_BYTE_ARRAY;
    private byte[] tQualities = EMPTY_BYTE_ARRAY;
    private short[] aPositions;
    private short[] cPositions;
    private short[] gPositions;
    private short[] tPositions;
    private Map<String, String> comments;
    private String id;

    public BasicChromatogramBuilder(String id) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        this.id = id;
    }

    private BasicChromatogramBuilder(String id, NucleotideSequence basecalls, PositionSequence peaks, ChannelGroup channelGroup, Map<String, String> properties) {
        this.id(id);
        this.basecalls(basecalls);
        this.peaks(peaks);
        this.channelGroup(channelGroup);
        this.comments(properties);
    }

    private void channelGroup(ChannelGroup channelGroup) {
        this.aQualities = this.toByteArray(channelGroup.getAChannel().getQualitySequence());
        this.aPositions = channelGroup.getAChannel().getPositionSequence().toArray();
        this.cQualities = this.toByteArray(channelGroup.getCChannel().getQualitySequence());
        this.cPositions = channelGroup.getCChannel().getPositionSequence().toArray();
        this.gConfidence = this.toByteArray(channelGroup.getGChannel().getQualitySequence());
        this.gPositions = channelGroup.getGChannel().getPositionSequence().toArray();
        this.tQualities = this.toByteArray(channelGroup.getTChannel().getQualitySequence());
        this.tPositions = channelGroup.getTChannel().getPositionSequence().toArray();
    }

    private byte[] toByteArray(QualitySequence sequence) {
        byte[] array = new byte[(int)sequence.getLength()];
        int i = 0;
        for (PhredQuality q : sequence) {
            array[i] = q.getQualityScore();
            ++i;
        }
        return array;
    }

    public BasicChromatogramBuilder(Chromatogram copy) {
        this(copy.getId(), copy.getNucleotideSequence(), copy.getPeakSequence(), copy.getChannelGroup(), copy.getComments());
    }

    public BasicChromatogramBuilder(String id, Chromatogram copy) {
        this(id, copy.getNucleotideSequence(), copy.getPeakSequence(), copy.getChannelGroup(), copy.getComments());
    }

    public final PositionSequence peaks() {
        return this.peaks;
    }

    public final BasicChromatogramBuilder peaks(PositionSequence peaks) {
        this.peaks = peaks;
        return this;
    }

    public final String id() {
        return this.id;
    }

    public BasicChromatogramBuilder id(String id) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        this.id = id;
        return this;
    }

    public NucleotideSequence basecalls() {
        return this.basecalls;
    }

    public BasicChromatogramBuilder basecalls(NucleotideSequence basecalls) {
        this.basecalls = basecalls;
        return this;
    }

    public byte[] aQualities() {
        return Arrays.copyOf(this.aQualities, this.aQualities.length);
    }

    public final BasicChromatogramBuilder aQualities(byte[] qualities) {
        this.aQualities = Arrays.copyOf(qualities, qualities.length);
        return this;
    }

    public byte[] cQualities() {
        return Arrays.copyOf(this.cQualities, this.cQualities.length);
    }

    public BasicChromatogramBuilder cQualities(byte[] qualities) {
        this.cQualities = Arrays.copyOf(qualities, qualities.length);
        return this;
    }

    public byte[] gQualities() {
        return Arrays.copyOf(this.gConfidence, this.gConfidence.length);
    }

    public BasicChromatogramBuilder gQualities(byte[] qualities) {
        this.gConfidence = Arrays.copyOf(qualities, qualities.length);
        return this;
    }

    public byte[] tQualities() {
        return Arrays.copyOf(this.tQualities, this.tQualities.length);
    }

    public BasicChromatogramBuilder tQualities(byte[] qualities) {
        this.tQualities = Arrays.copyOf(qualities, qualities.length);
        return this;
    }

    public short[] aPositions() {
        if (this.aPositions == null) {
            return new short[0];
        }
        return Arrays.copyOf(this.aPositions, this.aPositions.length);
    }

    public BasicChromatogramBuilder aPositions(short[] positions) {
        this.aPositions = Arrays.copyOf(positions, positions.length);
        return this;
    }

    public short[] cPositions() {
        if (this.cPositions == null) {
            return new short[0];
        }
        return Arrays.copyOf(this.cPositions, this.cPositions.length);
    }

    public BasicChromatogramBuilder cPositions(short[] positions) {
        this.cPositions = Arrays.copyOf(positions, positions.length);
        return this;
    }

    public short[] gPositions() {
        if (this.gPositions == null) {
            return new short[0];
        }
        return Arrays.copyOf(this.gPositions, this.gPositions.length);
    }

    public BasicChromatogramBuilder gPositions(short[] positions) {
        this.gPositions = Arrays.copyOf(positions, positions.length);
        return this;
    }

    public short[] tPositions() {
        if (this.tPositions == null) {
            return new short[0];
        }
        return Arrays.copyOf(this.tPositions, this.tPositions.length);
    }

    public BasicChromatogramBuilder tPositions(short[] positions) {
        this.tPositions = Arrays.copyOf(positions, positions.length);
        return this;
    }

    public Map<String, String> comments() {
        return this.comments == null ? Collections.emptyMap() : new LinkedHashMap<String, String>(this.comments);
    }

    public BasicChromatogramBuilder comments(Map<String, String> comments) {
        this.comments = new LinkedHashMap<String, String>(comments);
        return this;
    }

    private QualitySequence generateQualities(ChannelGroup channelGroup) {
        Nucleotide base;
        QualitySequence qualitySequence;
        int length = (int)this.basecalls.getLength();
        QualitySequenceBuilder builder = new QualitySequenceBuilder(length);
        int i = 0;
        Iterator iterator = this.basecalls.iterator();
        while (iterator.hasNext() && (long)i != (qualitySequence = channelGroup.getChannel(base = (Nucleotide)iterator.next()).getQualitySequence()).getLength()) {
            builder.append((PhredQuality)qualitySequence.get(i));
            ++i;
        }
        return builder.build();
    }

    public Chromatogram build() {
        DefaultChannelGroup channelGroup = new DefaultChannelGroup(new DefaultChannel(this.aQualities(), this.aPositions()), new DefaultChannel(this.cQualities(), this.cPositions()), new DefaultChannel(this.gQualities(), this.gPositions()), new DefaultChannel(this.tQualities(), this.tPositions()));
        return new BasicChromatogram(this.id, this.basecalls(), this.generateQualities(channelGroup), this.peaks(), (ChannelGroup)channelGroup, this.comments());
    }
}

