/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.trace.chromat;

import java.util.HashMap;
import java.util.Map;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.ObjectsUtil;
import org.jcvi.jillion.trace.chromat.ChannelGroup;
import org.jcvi.jillion.trace.chromat.Chromatogram;

public class BasicChromatogram
implements Chromatogram {
    private final ChannelGroup channelGroup;
    private final NucleotideSequence basecalls;
    private final QualitySequence qualities;
    private final PositionSequence positions;
    private final String id;
    private Map<String, String> properties;

    public BasicChromatogram(Chromatogram c) {
        this(c.getId(), c.getNucleotideSequence(), c.getQualitySequence(), c.getPeakSequence(), c.getChannelGroup(), c.getComments());
    }

    public BasicChromatogram(String id, NucleotideSequence basecalls, QualitySequence qualities, PositionSequence peaks, ChannelGroup channelGroup) {
        this(id, basecalls, qualities, peaks, channelGroup, new HashMap<String, String>());
    }

    public BasicChromatogram(String id, String basecalls, byte[] qualities, PositionSequence peaks, ChannelGroup channelGroup, Map<String, String> comments) {
        this(id, new NucleotideSequenceBuilder(basecalls).build(), new QualitySequenceBuilder(qualities).build(), peaks, channelGroup, comments);
    }

    public BasicChromatogram(String id, NucleotideSequence basecalls, QualitySequence qualities, PositionSequence peaks, ChannelGroup channelGroup, Map<String, String> comments) {
        this.canNotBeNull(id, basecalls, peaks, channelGroup, comments);
        this.id = id;
        this.positions = peaks;
        this.properties = comments;
        this.channelGroup = channelGroup;
        this.basecalls = basecalls;
        this.qualities = qualities;
    }

    private void canNotBeNull(Object ... objects) {
        for (Object obj : objects) {
            if (obj != null) continue;
            throw new IllegalArgumentException("null parameter");
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public NucleotideSequence getNucleotideSequence() {
        return this.basecalls;
    }

    @Override
    public PositionSequence getPeakSequence() {
        return this.positions;
    }

    @Override
    public Map<String, String> getComments() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.getChannelGroup().hashCode();
        result = 31 * result + (this.qualities == null ? 0 : this.qualities.hashCode());
        result = 31 * result + this.basecalls.hashCode();
        result = 31 * result + this.positions.hashCode();
        result = 31 * result + this.properties.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Chromatogram)) {
            return false;
        }
        Chromatogram other = (Chromatogram)obj;
        return this.id.equals(other.getId()) && ObjectsUtil.nullSafeEquals(this.getNucleotideSequence(), other.getNucleotideSequence()) && ObjectsUtil.nullSafeEquals(this.getQualitySequence(), other.getQualitySequence()) && ObjectsUtil.nullSafeEquals(this.getPeakSequence(), other.getPeakSequence()) && ObjectsUtil.nullSafeEquals(this.getChannelGroup(), other.getChannelGroup()) && ObjectsUtil.nullSafeEquals(this.getComments(), other.getComments());
    }

    @Override
    public ChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    @Override
    public QualitySequence getQualitySequence() {
        return this.qualities;
    }

    @Override
    public int getNumberOfTracePositions() {
        return (int)this.getChannelGroup().getAChannel().getPositionSequence().getLength();
    }
}

