/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.sam.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jcvi.jillion.internal.sam.SamUtil;
import org.jcvi.jillion.internal.sam.index.BinBuilder;
import org.jcvi.jillion.internal.sam.index.IndexUtil;
import org.jcvi.jillion.sam.VirtualFileOffset;
import org.jcvi.jillion.sam.index.Bin;
import org.jcvi.jillion.sam.index.Chunk;
import org.jcvi.jillion.sam.index.ReferenceIndex;

public final class ReferenceIndexBuilder {
    private final VirtualFileOffset[] intervals;
    private int largestIndexUsed = -1;
    private ArrayList<Bin> bins;
    private long numberOfUnalignedReads = 0L;
    private long numberOfAlignedReads = 0L;
    private VirtualFileOffset lowestStart = new VirtualFileOffset(Long.MAX_VALUE);
    private VirtualFileOffset higestEnd = new VirtualFileOffset(0L);
    private BinBuilder[] binBuilders;

    public ReferenceIndexBuilder(int length) {
        int arraySize = IndexUtil.getIntervalOffsetFor(length - 1);
        this.binBuilders = new BinBuilder[SamUtil.computeBinFor(length - 1, length) + 1];
        this.intervals = new VirtualFileOffset[arraySize + 1];
    }

    public void addAlignment(int readStartOffset, int readEndOffsetExclusive, VirtualFileOffset start, VirtualFileOffset end) {
        this.updateIntervals(readStartOffset, readEndOffsetExclusive - 1, start, end);
        this.updateBins(readStartOffset, readEndOffsetExclusive, start, end);
    }

    public void incrementUnmappedCount() {
        ++this.numberOfUnalignedReads;
    }

    public ReferenceIndex build() {
        this.bins = new ArrayList(this.binBuilders.length);
        for (int i = 0; i < this.binBuilders.length; ++i) {
            if (this.binBuilders[i] == null) continue;
            this.bins.add(this.binBuilders[i].build());
        }
        this.bins.trimToSize();
        return new ReferenceIndexImpl(this);
    }

    private void updateBins(int readStartOffset, int readEndOffsetExclusive, VirtualFileOffset start, VirtualFileOffset end) {
        BinBuilder binBuilder;
        int bin = SamUtil.computeBinFor(readStartOffset, readEndOffsetExclusive);
        if (this.binBuilders[bin] == null) {
            this.binBuilders[bin] = binBuilder = new BinBuilder(bin);
        } else {
            binBuilder = this.binBuilders[bin];
        }
        binBuilder.addChunk(new Chunk(start, end));
        ++this.numberOfAlignedReads;
    }

    public void updateIntervals(int readStartOffset, int readEndOffset, VirtualFileOffset start, VirtualFileOffset end) {
        int startInterval = IndexUtil.getIntervalOffsetFor(readStartOffset);
        int endInterval = IndexUtil.getIntervalOffsetFor(readEndOffset);
        if (endInterval > this.largestIndexUsed) {
            this.largestIndexUsed = endInterval;
        }
        for (int i = startInterval; i <= endInterval; ++i) {
            VirtualFileOffset currentValue = this.intervals[i];
            if (currentValue != null && start.compareTo(currentValue) >= 0) continue;
            this.intervals[i] = start;
            continue;
        }
        if (start.compareTo(this.lowestStart) < 0) {
            this.lowestStart = start;
        }
        if (end.compareTo(this.higestEnd) > 0) {
            this.higestEnd = end;
        }
    }

    private static final class ReferenceIndexImpl
    implements ReferenceIndex {
        private final List<Bin> bins;
        private final VirtualFileOffset[] intervals;
        private final Long numberOfUnAlignedReads;
        private final Long numberOfAlignedReads;
        private final VirtualFileOffset lowestOffset;
        private final VirtualFileOffset highestOffset;

        private ReferenceIndexImpl(ReferenceIndexBuilder builder) {
            this.bins = builder.bins;
            this.intervals = Arrays.copyOf(builder.intervals, builder.largestIndexUsed + 1);
            VirtualFileOffset prev = new VirtualFileOffset(0L);
            for (int i = 0; i < this.intervals.length; ++i) {
                if (this.intervals[i] == null) {
                    this.intervals[i] = prev;
                    continue;
                }
                prev = this.intervals[i];
            }
            this.numberOfUnAlignedReads = builder.numberOfUnalignedReads;
            this.numberOfAlignedReads = builder.numberOfAlignedReads;
            this.lowestOffset = builder.lowestStart;
            this.highestOffset = builder.higestEnd;
        }

        @Override
        public Long getNumberOfUnAlignedReads() {
            return this.numberOfUnAlignedReads;
        }

        @Override
        public Long getNumberOfAlignedReads() {
            return this.numberOfAlignedReads;
        }

        @Override
        public boolean hasMetaData() {
            return true;
        }

        @Override
        public int getNumberOfBins() {
            return this.bins.size();
        }

        @Override
        public VirtualFileOffset getLowestStartOffset() {
            return this.lowestOffset;
        }

        @Override
        public VirtualFileOffset getHighestEndOffset() {
            return this.highestOffset;
        }

        @Override
        public List<Bin> getBins() {
            return Collections.unmodifiableList(this.bins);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bins == null ? 0 : this.bins.hashCode());
            result = 31 * result + Arrays.hashCode(this.intervals);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ReferenceIndex)) {
                return false;
            }
            ReferenceIndex other = (ReferenceIndex)obj;
            if (!this.bins.equals(other.getBins())) {
                return false;
            }
            return Arrays.equals(this.intervals, other.getIntervals());
        }

        @Override
        public VirtualFileOffset[] getIntervals() {
            return Arrays.copyOf(this.intervals, this.intervals.length);
        }

        public String toString() {
            return "ReferenceIndexImpl [bins=" + this.bins + ", intervals=" + Arrays.toString(this.intervals) + "]";
        }
    }
}

