/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.sam.index;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.core.util.JillionUtil;
import org.jcvi.jillion.internal.sam.SamUtil;
import org.jcvi.jillion.internal.sam.index.BaiBin;
import org.jcvi.jillion.internal.sam.index.BaiRefIndex;
import org.jcvi.jillion.sam.VirtualFileOffset;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.header.SamReferenceSequence;
import org.jcvi.jillion.sam.index.BamIndex;
import org.jcvi.jillion.sam.index.Bin;
import org.jcvi.jillion.sam.index.Chunk;
import org.jcvi.jillion.sam.index.ReferenceIndex;

public final class IndexUtil {
    private static final int METADATA_BIN_ID = 37450;
    private static final int INTERVAL_SHIFT = 14;
    private static final byte[] BAM_INDEX_MAGIC = new byte[]{66, 65, 73, 1};

    private IndexUtil() {
    }

    public static int getIntervalOffsetFor(int genomicOffset) {
        return genomicOffset >> 14;
    }

    public static BamIndex parseIndex(InputStream in, SamHeader header) throws IOException {
        byte[] magicNumber = IOUtil.readByteArray(in, 4);
        if (!Arrays.equals(BAM_INDEX_MAGIC, magicNumber)) {
            throw new IOException("invalid magic number : " + Arrays.toString(magicNumber));
        }
        int numRefs = IOUtil.readSignedInt(in, ByteOrder.LITTLE_ENDIAN);
        ArrayList<ReferenceIndex> refIndexes = new ArrayList<ReferenceIndex>(numRefs);
        Iterator<SamReferenceSequence> refSeqIer = header.getReferenceSequences().iterator();
        for (int i = 0; i < numRefs; ++i) {
            int numBins = IOUtil.readSignedInt(in, ByteOrder.LITTLE_ENDIAN);
            if (!refSeqIer.hasNext()) {
                throw new NullPointerException("no ref " + i);
            }
            SamReferenceSequence refSeq = refSeqIer.next();
            int maxBin = SamUtil.computeBinFor(new Range.Builder(1L).shift(refSeq.getLength()).build());
            Bin[] bins = new Bin[numBins];
            int numOfBinsUsed = 0;
            VirtualFileOffset lowestStart = null;
            VirtualFileOffset highestEnd = null;
            Long alignedCount = null;
            Long unAlignedCount = null;
            for (int j = 0; j < numBins; ++j) {
                int binId = IOUtil.readSignedInt(in, ByteOrder.LITTLE_ENDIAN);
                int numChunks = IOUtil.readSignedInt(in, ByteOrder.LITTLE_ENDIAN);
                Chunk[] chunks = new Chunk[numChunks];
                for (int k = 0; k < numChunks; ++k) {
                    VirtualFileOffset begin = IndexUtil.readVirtualFileOffset(in);
                    VirtualFileOffset end = IndexUtil.readVirtualFileOffset(in);
                    chunks[k] = new Chunk(begin, end);
                }
                if (binId == 37450 && maxBin < 37450) {
                    lowestStart = chunks[0].getBegin();
                    highestEnd = chunks[0].getEnd();
                    alignedCount = chunks[1].getBegin().getEncodedValue();
                    unAlignedCount = chunks[1].getEnd().getEncodedValue();
                    continue;
                }
                bins[j] = new BaiBin(binId, chunks);
                ++numOfBinsUsed;
            }
            int numIntervals = IOUtil.readSignedInt(in, ByteOrder.LITTLE_ENDIAN);
            VirtualFileOffset[] intervals = new VirtualFileOffset[numIntervals];
            for (int j = 0; j < numIntervals; ++j) {
                intervals[j] = IndexUtil.readVirtualFileOffset(in);
            }
            BaiRefIndex ref = new BaiRefIndex(Arrays.copyOf(bins, numOfBinsUsed), intervals);
            ref.setLowestStartOffset(lowestStart);
            ref.setHighestEndOffset(highestEnd);
            ref.setAlignedCount(alignedCount);
            ref.setUnalignedCount(unAlignedCount);
            refIndexes.add(ref);
        }
        PushbackInputStream in2 = new PushbackInputStream(in, 1);
        int value = in.read();
        if (value == -1) {
            return new BamIndex(header, refIndexes);
        }
        in2.unread(value);
        long numUnMapped = IOUtil.readSignedLong(in2, ByteOrder.LITTLE_ENDIAN);
        return new BamIndex(header, refIndexes, numUnMapped);
    }

    private static VirtualFileOffset readVirtualFileOffset(InputStream in) throws IOException {
        return new VirtualFileOffset(IOUtil.readSignedLong(in, ByteOrder.LITTLE_ENDIAN));
    }

    public static void writeIndex(OutputStream out, BamIndex indexes) throws IOException {
        IndexUtil.writeIndex(out, indexes, false);
    }

    public static void writeIndex(OutputStream out, BamIndex indexes, boolean includeMetaData) throws IOException {
        out.write(BAM_INDEX_MAGIC);
        int numberOfIndexes = indexes.getNumberOfReferenceIndexes();
        IOUtil.putInt(out, numberOfIndexes, ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < numberOfIndexes; ++i) {
            List<Bin> bins;
            ReferenceIndex refIndex = indexes.getReferenceIndex(i);
            if (includeMetaData) {
                bins = new ArrayList<Bin>(refIndex.getBins());
                Bin metaDataBin = IndexUtil.createFakeMetaDataBin(refIndex);
                if (metaDataBin != null) {
                    bins.add(metaDataBin);
                }
            } else {
                bins = refIndex.getBins();
            }
            IOUtil.putInt(out, bins.size(), ByteOrder.LITTLE_ENDIAN);
            for (Bin bin : bins) {
                IOUtil.putInt(out, bin.getBinNumber(), ByteOrder.LITTLE_ENDIAN);
                List<Chunk> chunks = bin.getChunks();
                IOUtil.putInt(out, chunks.size(), ByteOrder.LITTLE_ENDIAN);
                for (Chunk chunk : chunks) {
                    IOUtil.putLong(out, chunk.getBegin().getEncodedValue(), ByteOrder.LITTLE_ENDIAN);
                    IOUtil.putLong(out, chunk.getEnd().getEncodedValue(), ByteOrder.LITTLE_ENDIAN);
                }
            }
            VirtualFileOffset[] intervals = refIndex.getIntervals();
            IOUtil.putInt(out, intervals.length, ByteOrder.LITTLE_ENDIAN);
            long prev = 0L;
            for (int j = 0; j < intervals.length; ++j) {
                VirtualFileOffset current = intervals[j];
                if (current == null) {
                    IOUtil.putLong(out, prev, ByteOrder.LITTLE_ENDIAN);
                    continue;
                }
                long encodedValue = current.getEncodedValue();
                IOUtil.putLong(out, encodedValue, ByteOrder.LITTLE_ENDIAN);
                prev = encodedValue;
            }
        }
        if (includeMetaData) {
            Long count = indexes.getTotalNumberOfUnmappedReads();
            IOUtil.putLong(out, count == null ? 0L : count, ByteOrder.LITTLE_ENDIAN);
        }
        out.close();
    }

    private static Bin createFakeMetaDataBin(ReferenceIndex refIndex) {
        if (!refIndex.hasMetaData() || refIndex.getNumberOfBins() == 0) {
            return null;
        }
        Chunk[] chunks = new Chunk[]{new Chunk(refIndex.getLowestStartOffset(), refIndex.getHighestEndOffset()), new Chunk(new VirtualFileOffset(refIndex.getNumberOfAlignedReads()), new VirtualFileOffset(refIndex.getNumberOfUnAlignedReads()))};
        return new BaiBin(37450, chunks);
    }

    public static enum BinSorter implements Comparator<Bin>
    {
        INSTANCE;


        @Override
        public int compare(Bin o1, Bin o2) {
            return JillionUtil.compare(o1.getBinNumber(), o2.getBinNumber());
        }
    }
}

