/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.sam.index;

import java.util.ArrayList;
import java.util.List;
import org.jcvi.jillion.sam.index.Bin;
import org.jcvi.jillion.sam.index.Chunk;

public final class BinBuilder {
    private final int binNumber;
    private final List<Chunk> chunks = new ArrayList<Chunk>();

    public BinBuilder(int binNumber) {
        this.binNumber = binNumber;
    }

    public BinBuilder addChunk(Chunk chunk) {
        if (chunk == null) {
            throw new NullPointerException("chunk can not be null");
        }
        if (this.chunks.isEmpty()) {
            this.chunks.add(chunk);
        } else {
            int lastChunkOffset = this.chunks.size() - 1;
            Chunk lastChunk = this.chunks.get(lastChunkOffset);
            if (this.canBeMerged(lastChunk, chunk)) {
                Chunk mergedChunk = new Chunk(lastChunk.getBegin(), chunk.getEnd());
                this.chunks.set(lastChunkOffset, mergedChunk);
            } else {
                this.chunks.add(chunk);
            }
        }
        return this;
    }

    private boolean canBeMerged(Chunk c1, Chunk c2) {
        long startBlockOffsetOf2;
        long endBlockOffsetOf1 = c1.getEnd().getCompressedBamBlockOffset();
        return endBlockOffsetOf1 == (startBlockOffsetOf2 = c2.getBegin().getCompressedBamBlockOffset()) || endBlockOffsetOf1 + 1L == startBlockOffsetOf2;
    }

    public Bin build() {
        return new BinImpl(this);
    }

    private static final class BinImpl
    implements Bin {
        private final int binNumber;
        private final List<Chunk> chunks;

        private BinImpl(BinBuilder builder) {
            this.binNumber = builder.binNumber;
            this.chunks = new ArrayList<Chunk>(builder.chunks);
        }

        @Override
        public int getBinNumber() {
            return this.binNumber;
        }

        @Override
        public List<Chunk> getChunks() {
            return this.chunks;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.binNumber;
            result = 31 * result + this.chunks.hashCode();
            return result;
        }

        public String toString() {
            return "Bin [binNumber=" + this.binNumber + ", chunks=" + this.chunks + "]";
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Bin)) {
                return false;
            }
            Bin other = (Bin)obj;
            if (this.binNumber != other.getBinNumber()) {
                return false;
            }
            return this.chunks.equals(other.getChunks());
        }
    }
}

