/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.sam.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.internal.sam.IndexerCallback;
import org.jcvi.jillion.internal.sam.index.ReferenceIndexBuilder;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.VirtualFileOffset;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.header.SamReferenceSequence;
import org.jcvi.jillion.sam.index.BamIndex;
import org.jcvi.jillion.sam.index.ReferenceIndex;

public class BamIndexer
implements IndexerCallback {
    private SamRecord currentRecord;
    private long totalNumberOfUnmappedReads = 0L;
    private final SamHeader header;
    private final List<ReferenceIndexBuilder> indexBuilders;
    private ReferenceIndexBuilder currentBuilder;
    private String currentRefName;
    private Map<String, Integer> refSeqIndexMap = new HashMap<String, Integer>();

    public BamIndexer(SamHeader header) {
        this.header = header;
        Collection<SamReferenceSequence> referenceSequences = header.getReferenceSequences();
        this.indexBuilders = new ArrayList<ReferenceIndexBuilder>(referenceSequences.size());
        int i = 0;
        for (SamReferenceSequence refSeq : referenceSequences) {
            this.indexBuilders.add(new ReferenceIndexBuilder(refSeq.getLength()));
            this.refSeqIndexMap.put(refSeq.getName(), i);
            ++i;
        }
    }

    public void setCurrentRecord(SamRecord record) {
        this.currentRecord = record;
    }

    public void addRecord(SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
        if (record == null) {
            return;
        }
        if (record.mapped()) {
            String ref = record.getReferenceName();
            if (!ref.equals(this.currentRefName)) {
                int refIndex = this.refSeqIndexMap.get(ref);
                this.currentBuilder = this.indexBuilders.get(refIndex);
                this.currentRefName = ref;
            }
            int readStartOffset = record.getStartPosition() - 1;
            int readLength = record.getCigar().getNumberOfReferenceBasesAligned();
            this.currentBuilder.addAlignment(readStartOffset, readStartOffset + readLength, start, end);
        } else {
            ++this.totalNumberOfUnmappedReads;
        }
    }

    @Override
    public void encodedIndex(VirtualFileOffset start, VirtualFileOffset end) {
        this.addRecord(this.currentRecord, start, end);
    }

    public BamIndex createBamIndex() {
        return new BamIndex(this.header, this.createReferenceIndexes(), this.totalNumberOfUnmappedReads);
    }

    private List<ReferenceIndex> createReferenceIndexes() {
        ArrayList<ReferenceIndex> list = new ArrayList<ReferenceIndex>(this.indexBuilders.size());
        for (ReferenceIndexBuilder builder : this.indexBuilders) {
            ReferenceIndex refIndex = builder.build();
            list.add(refIndex);
        }
        return list;
    }

    public long getTotalNumberOfUnmappedReads() {
        return this.totalNumberOfUnmappedReads;
    }
}

