/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.sam.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jcvi.jillion.internal.sam.index.IndexUtil;
import org.jcvi.jillion.sam.VirtualFileOffset;
import org.jcvi.jillion.sam.index.Bin;
import org.jcvi.jillion.sam.index.ReferenceIndex;

class BaiRefIndex
implements ReferenceIndex {
    private final List<Bin> bins;
    private VirtualFileOffset[] intervals;
    private Long unalignedCount;
    private Long alignedCount;
    private VirtualFileOffset lowestStart;
    private VirtualFileOffset highestEnd;

    public BaiRefIndex(Bin[] bins, VirtualFileOffset[] intervals) {
        this.intervals = intervals;
        ArrayList<Bin> binList = new ArrayList<Bin>(bins.length);
        for (Bin b : bins) {
            if (b == null) continue;
            binList.add(b);
        }
        Collections.sort(binList, IndexUtil.BinSorter.INSTANCE);
        this.bins = Collections.unmodifiableList(binList);
    }

    @Override
    public List<Bin> getBins() {
        return this.bins;
    }

    @Override
    public int getNumberOfBins() {
        return this.bins.size();
    }

    @Override
    public boolean hasMetaData() {
        return this.lowestStart != null && this.highestEnd != null && this.alignedCount != null && this.unalignedCount != null;
    }

    @Override
    public VirtualFileOffset getLowestStartOffset() {
        return this.lowestStart;
    }

    public void setLowestStartOffset(VirtualFileOffset lowestStart) {
        this.lowestStart = lowestStart;
    }

    @Override
    public VirtualFileOffset getHighestEndOffset() {
        return this.highestEnd;
    }

    public void setHighestEndOffset(VirtualFileOffset highestEnd) {
        this.highestEnd = highestEnd;
    }

    public void setUnalignedCount(Long unalignedCount) {
        this.unalignedCount = unalignedCount;
    }

    public void setAlignedCount(Long alignedCount) {
        this.alignedCount = alignedCount;
    }

    @Override
    public Long getNumberOfUnAlignedReads() {
        return this.unalignedCount;
    }

    @Override
    public Long getNumberOfAlignedReads() {
        return this.alignedCount;
    }

    @Override
    public VirtualFileOffset[] getIntervals() {
        return Arrays.copyOf(this.intervals, this.intervals.length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bins.hashCode();
        result = 31 * result + Arrays.hashCode(this.intervals);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceIndex)) {
            return false;
        }
        ReferenceIndex other = (ReferenceIndex)obj;
        if (!this.bins.equals(other.getBins())) {
            return false;
        }
        return Arrays.equals(this.intervals, other.getIntervals());
    }

    public String toString() {
        return "BaiRefIndex [bins=" + this.bins + ", intervals=" + Arrays.toString(this.intervals) + "]";
    }
}

