/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.sam.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jcvi.jillion.sam.index.Bin;
import org.jcvi.jillion.sam.index.Chunk;

class BaiBin
implements Bin {
    private int binId;
    private List<Chunk> chunks;

    public BaiBin(int binId, Chunk[] chunks) {
        this.binId = binId;
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>(chunks.length);
        for (Chunk c : chunks) {
            chunkList.add(c);
        }
        this.chunks = Collections.unmodifiableList(chunkList);
    }

    @Override
    public int getBinNumber() {
        return this.binId;
    }

    @Override
    public List<Chunk> getChunks() {
        return this.chunks;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.binId;
        result = 31 * result + this.chunks.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bin)) {
            return false;
        }
        Bin other = (Bin)obj;
        if (this.binId != other.getBinNumber()) {
            return false;
        }
        return this.chunks.equals(other.getChunks());
    }

    public String toString() {
        return "BaiBin [binId=" + this.binId + ", chunks=" + this.chunks + "]";
    }
}

