/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.sam;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.attribute.SamAttribute;
import org.jcvi.jillion.sam.attribute.SamAttributeKey;
import org.jcvi.jillion.sam.attribute.SamAttributeType;
import org.jcvi.jillion.sam.cigar.Cigar;
import org.jcvi.jillion.sam.cigar.CigarElement;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.header.SamProgram;
import org.jcvi.jillion.sam.header.SamReadGroup;
import org.jcvi.jillion.sam.header.SamReferenceSequence;

@SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"})
public final class SamUtil {
    private static final char COLON = ':';
    private static final char TAB = '\t';
    private static final int MAX_BIN = 37449;
    private static final int[] BIN_TREE_LEVEL_OFFSETS;
    private static final int[] BIN_TREE_LEVEL_SHIFTS;
    private static final byte[] BAM_MAGIC_NUMBER;
    private static ThreadLocal<DateFormat> THREAD_LOCAL_DATE_FORMAT;
    private static final Nucleotide[] BAM_ENCODED_BASES;
    private static final byte[] BAM_ORDINAL_TO_ENCODED_BASES;
    private static final Nucleotide[][] PAIR_OF_BAM_ENCODED_BASES;
    private static final byte[][] PAIR_OF_BASES_TO_BAM_ENCODE;

    private SamUtil() {
    }

    public static final byte[] getBamMagicNumber() {
        return Arrays.copyOf(BAM_MAGIC_NUMBER, 4);
    }

    public static boolean matchesBamMagicNumber(byte[] b) {
        return Arrays.equals(BAM_MAGIC_NUMBER, b);
    }

    public static NucleotideSequence readBamEncodedSequence(InputStream in, int seqLength) throws IOException {
        byte[] seqBytes = new byte[(seqLength + 1) / 2];
        IOUtil.blockingRead(in, seqBytes);
        NucleotideSequenceBuilder builder = new NucleotideSequenceBuilder(seqLength);
        builder.turnOffDataCompression(true);
        if (seqBytes.length > 1) {
            Nucleotide[] array = new Nucleotide[(seqBytes.length - 1) * 2];
            int j = 0;
            for (int i = 0; i < seqBytes.length - 1; ++i) {
                Nucleotide[] pair = PAIR_OF_BAM_ENCODED_BASES[seqBytes[i] & 0xFF];
                array[j++] = pair[0];
                array[j++] = pair[1];
            }
            builder.append(array);
        }
        byte lastByte = seqBytes[seqBytes.length - 1];
        builder.append(BAM_ENCODED_BASES[lastByte >> 4 & 0xF]);
        if (seqLength % 2 == 0) {
            builder.append(BAM_ENCODED_BASES[lastByte & 0xF]);
        }
        return builder.build();
    }

    public static boolean isValidKey(char key1, char key2) {
        return SamUtil.assertValid1(key1) && SamUtil.assertValid2(key2);
    }

    private static boolean assertValid1(char c) {
        if (c < 'A' || c > 'z') {
            return false;
        }
        return c <= 'Z' || c >= 'a';
    }

    private static boolean assertValid2(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        return SamUtil.assertValid1(c);
    }

    public static Date toDate(String dateString) throws ParseException {
        return THREAD_LOCAL_DATE_FORMAT.get().parse(dateString);
    }

    public static String formatIsoDate(Date date) {
        return THREAD_LOCAL_DATE_FORMAT.get().format(date);
    }

    public static int computeBinFor(Range range) {
        return SamUtil.computeBinFor((int)range.getBegin(), (int)range.getEnd() + 1);
    }

    public static int computeBinFor(int begin, int endExclusive) {
        if (endExclusive <= begin) {
            throw new IllegalArgumentException("end must be > begin : " + begin + "  " + endExclusive);
        }
        int beg = begin;
        int end = endExclusive - 1;
        if (beg >> 14 == end >> 14) {
            return 4681 + (beg >> 14);
        }
        if (beg >> 17 == end >> 17) {
            return 585 + (beg >> 17);
        }
        if (beg >> 20 == end >> 20) {
            return 73 + (beg >> 20);
        }
        if (beg >> 23 == end >> 23) {
            return 9 + (beg >> 23);
        }
        if (beg >> 26 == end >> 26) {
            return 1 + (beg >> 26);
        }
        return 0;
    }

    public static int[] getCandidateOverlappingBins(Range range) {
        return SamUtil.getCandidateOverlappingBins((int)range.getBegin(), (int)range.getEnd() + 1);
    }

    public static int[] getCandidateOverlappingBins(int begin, int endExclusive) {
        if (endExclusive <= begin) {
            throw new IllegalArgumentException("end must be > begin");
        }
        int end = endExclusive - 1;
        int beg = begin;
        int[] list = new int[37449];
        int i = 0;
        list[i++] = 0;
        for (int level = 0; level < BIN_TREE_LEVEL_OFFSETS.length; ++level) {
            int shiftAmount = BIN_TREE_LEVEL_SHIFTS[level];
            int initialK = BIN_TREE_LEVEL_OFFSETS[level];
            int k = initialK + (beg >> shiftAmount);
            while (k <= initialK + (end >> shiftAmount)) {
                list[i++] = k++;
            }
        }
        return Arrays.copyOf(list, i);
    }

    public static void writeAsBamRecord(OutputStream out, SamHeader header, SamRecord record, int refIndex, int nextNameIndex) throws IOException {
        long bin;
        Cigar cigar;
        ByteBuffer buf = ByteBuffer.allocate(8096);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.position(4);
        buf.putInt(refIndex);
        int startOffset = record.getStartPosition() - 1;
        buf.putInt(startOffset);
        if (record.mapped()) {
            cigar = record.getCigar();
            int refAlignLength = cigar.getNumberOfReferenceBasesAligned();
            bin = SamUtil.computeBinFor(startOffset, startOffset + refAlignLength);
        } else {
            bin = 4680L;
            cigar = Cigar.EMPTY_CIGAR;
        }
        bin <<= 16;
        bin |= (long)(record.getMappingQuality() << 8);
        long flagsAndNumCigarOps = record.getFlags().asInt() << 16;
        buf.putInt((int)((bin |= (long)(record.getQueryName().length() + 1)) & 0xFFFFFFFFL));
        buf.putInt((int)((flagsAndNumCigarOps |= (long)cigar.getNumberOfElements()) & 0xFFFFFFFFL));
        NucleotideSequence seq = record.getSequence();
        int seqLength = seq == null ? 0 : (int)seq.getLength();
        buf.putInt(seqLength);
        buf.putInt(nextNameIndex);
        buf.putInt(record.getNextOffset() - 1);
        buf.putInt(record.getObservedTemplateLength());
        buf.put(SamUtil.writeNullTerminatedStringAsBytes(record.getQueryName()));
        for (CigarElement cigarElement : cigar) {
            int encodedCigar = cigarElement.getLength() << 4;
            buf.putInt(encodedCigar |= cigarElement.getOp().getBinaryOpCode());
        }
        if (seqLength > 0) {
            SamUtil.writeSequence(buf, seqLength, seq);
            SamUtil.writeQualities(buf, seqLength, record.getQualities());
        }
        for (SamAttribute attribute : record.getAttributes()) {
            SamAttributeKey key = attribute.getKey();
            buf.put((byte)(key.getFirstChar() & 0xFF));
            buf.put((byte)(key.getSecondChar() & 0xFF));
            SamAttributeType type = attribute.getType();
            type.encodeInBam(attribute.getValue(), buf);
        }
        int bytesWritten = buf.position();
        buf.position(0);
        buf.putInt(bytesWritten - 4);
        out.write(Arrays.copyOf(buf.array(), bytesWritten));
    }

    private static void writeQualities(ByteBuffer in, int seqLength, QualitySequence qualities) throws IOException {
        if (qualities == null) {
            byte[] fake = new byte[seqLength];
            Arrays.fill(fake, (byte)-1);
            in.put(fake);
        } else {
            in.put(qualities.toArray());
        }
    }

    private static void writeSequence(ByteBuffer buf, int seqLength, NucleotideSequence seq) throws IOException {
        byte[] data = new byte[(seqLength + 1) / 2];
        Iterator iter = seq.iterator();
        for (int i = 0; i < data.length - 1; ++i) {
            data[i] = PAIR_OF_BASES_TO_BAM_ENCODE[((Nucleotide)iter.next()).ordinal()][((Nucleotide)iter.next()).ordinal()];
        }
        int value = BAM_ORDINAL_TO_ENCODED_BASES[((Nucleotide)iter.next()).ordinal()] << 4;
        if (seqLength % 2 == 0) {
            value |= BAM_ORDINAL_TO_ENCODED_BASES[((Nucleotide)iter.next()).ordinal()];
        }
        data[data.length - 1] = (byte)value;
        buf.put(data);
    }

    private static byte[] writeNullTerminatedStringAsBytes(String s) {
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length + 1];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static StringBuilder encodeHeader(SamHeader header) {
        StringBuilder builder;
        StringBuilder out = new StringBuilder(1024);
        if (header.getVersion() != null) {
            out.append(String.format("@HD\tVN:%s\tSO:%s\n", header.getVersion(), header.getSortOrder().getEncodedName()));
        }
        for (SamReferenceSequence seq : header.getReferenceSequences()) {
            builder = new StringBuilder(300);
            builder.append("@SQ\tSN:").append(seq.getName()).append("\tLN:").append(seq.getLength());
            SamUtil.appendIfNotNull(builder, "AS", seq.getGenomeAssemblyId());
            SamUtil.appendIfNotNull(builder, "M5", seq.getMd5());
            SamUtil.appendIfNotNull(builder, "SP", seq.getSpecies());
            SamUtil.appendIfNotNull(builder, "UR", seq.getUri());
            out.append(String.format("%s\n", builder.toString()));
        }
        for (SamReadGroup readGroup : header.getReadGroups()) {
            builder = new StringBuilder(1024);
            builder.append("@RG\tID:").append(readGroup.getId());
            SamUtil.appendIfNotNull(builder, "CN", readGroup.getSequencingCenter());
            SamUtil.appendIfNotNull(builder, "DS", readGroup.getDescription());
            SamUtil.appendIsoDateIfNotNull(builder, "DT", readGroup.getRunDate());
            SamUtil.appendIfNotNull(builder, "FO", readGroup.getFlowOrder());
            SamUtil.appendIfNotNull(builder, "KS", readGroup.getKeySequence());
            SamUtil.appendIfNotNull(builder, "LB", readGroup.getLibrary());
            SamUtil.appendIfNotNull(builder, "PG", readGroup.getPrograms());
            SamUtil.appendIfNotNull(builder, "PI", readGroup.getPredictedInsertSize());
            SamUtil.appendIfNotNull(builder, "PL", (Object)readGroup.getPlatform());
            SamUtil.appendIfNotNull(builder, "PU", readGroup.getPlatformUnit());
            SamUtil.appendIfNotNull(builder, "SM", readGroup.getSampleOrPoolName());
            out.append(String.format("%s\n", builder.toString()));
        }
        for (SamProgram program : header.getPrograms()) {
            builder = new StringBuilder(1024);
            builder.append(String.format("@PG\tID:%s", program.getId()));
            SamUtil.appendIfNotNull(builder, "PN", program.getName());
            SamUtil.appendIfNotNull(builder, "CL", program.getCommandLine());
            SamUtil.appendIfNotNull(builder, "PP", program.getPreviousProgramId());
            SamUtil.appendIfNotNull(builder, "DS", program.getDescription());
            SamUtil.appendIfNotNull(builder, "VN", program.getVersion());
            out.append(String.format("%s\n", builder.toString()));
        }
        for (String comment : header.getComments()) {
            out.append(String.format("@CO\t%s\n", comment));
        }
        return out;
    }

    private static void appendIsoDateIfNotNull(StringBuilder builder, String key, Date value) {
        if (value != null) {
            builder.append('\t').append(key).append(':').append(SamUtil.formatIsoDate(value));
        }
    }

    private static void appendIfNotNull(StringBuilder builder, String key, Object value) {
        if (value != null) {
            builder.append('\t').append(key).append(':').append(value);
        }
    }

    public static Predicate<SamRecord> alignsToReference(String referenceName) {
        Objects.requireNonNull(referenceName, "reference name can not be null");
        return record -> referenceName.equals(record.getReferenceName());
    }

    public static Predicate<SamRecord> alignsToReference(String referenceName, Range alignmentRegionOfInterest) {
        Objects.requireNonNull(referenceName, "reference name can not be null");
        Objects.requireNonNull(alignmentRegionOfInterest, "alignment range can not be null");
        return record -> {
            if (referenceName.equals(record.getReferenceName())) {
                return alignmentRegionOfInterest.intersects(record.getAlignmentRange());
            }
            return false;
        };
    }

    static {
        int i;
        BIN_TREE_LEVEL_OFFSETS = new int[]{1, 9, 73, 585, 4681};
        BIN_TREE_LEVEL_SHIFTS = new int[]{26, 23, 20, 17, 14};
        BAM_MAGIC_NUMBER = new byte[]{66, 65, 77, 1};
        THREAD_LOCAL_DATE_FORMAT = new ThreadLocal<DateFormat>(){

            @Override
            public DateFormat get() {
                return (DateFormat)super.get();
            }

            @Override
            protected DateFormat initialValue() {
                return new SamDateFormat();
            }

            @Override
            public void remove() {
                super.remove();
            }

            @Override
            public void set(DateFormat value) {
                super.set(value);
            }
        };
        BAM_ENCODED_BASES = new Nucleotide[16];
        SamUtil.BAM_ENCODED_BASES[0] = null;
        SamUtil.BAM_ENCODED_BASES[1] = Nucleotide.Adenine;
        SamUtil.BAM_ENCODED_BASES[2] = Nucleotide.Cytosine;
        SamUtil.BAM_ENCODED_BASES[3] = Nucleotide.Amino;
        SamUtil.BAM_ENCODED_BASES[4] = Nucleotide.Guanine;
        SamUtil.BAM_ENCODED_BASES[5] = Nucleotide.Purine;
        SamUtil.BAM_ENCODED_BASES[6] = Nucleotide.Strong;
        SamUtil.BAM_ENCODED_BASES[7] = Nucleotide.NotThymine;
        SamUtil.BAM_ENCODED_BASES[8] = Nucleotide.Thymine;
        SamUtil.BAM_ENCODED_BASES[9] = Nucleotide.Weak;
        SamUtil.BAM_ENCODED_BASES[10] = Nucleotide.Pyrimidine;
        SamUtil.BAM_ENCODED_BASES[11] = Nucleotide.NotGuanine;
        SamUtil.BAM_ENCODED_BASES[12] = Nucleotide.Keto;
        SamUtil.BAM_ENCODED_BASES[13] = Nucleotide.NotCytosine;
        SamUtil.BAM_ENCODED_BASES[14] = Nucleotide.NotAdenine;
        SamUtil.BAM_ENCODED_BASES[15] = Nucleotide.Unknown;
        BAM_ORDINAL_TO_ENCODED_BASES = new byte[16];
        for (i = 0; i < 16; ++i) {
            Nucleotide n = BAM_ENCODED_BASES[i];
            if (n == null) continue;
            SamUtil.BAM_ORDINAL_TO_ENCODED_BASES[n.ordinal()] = (byte)i;
        }
        PAIR_OF_BAM_ENCODED_BASES = new Nucleotide[256][2];
        for (i = 1; i < BAM_ENCODED_BASES.length; ++i) {
            int shiftedI = i << 4;
            for (int j = 1; j < BAM_ENCODED_BASES.length; ++j) {
                int value = shiftedI | j;
                SamUtil.PAIR_OF_BAM_ENCODED_BASES[value] = new Nucleotide[]{BAM_ENCODED_BASES[i], BAM_ENCODED_BASES[j]};
            }
        }
        Nucleotide[] ordinals = (Nucleotide[])Nucleotide.getDnaValues().stream().toArray(Nucleotide[]::new);
        PAIR_OF_BASES_TO_BAM_ENCODE = new byte[ordinals.length][ordinals.length];
        for (Nucleotide a : ordinals) {
            for (Nucleotide b : ordinals) {
                SamUtil.PAIR_OF_BASES_TO_BAM_ENCODE[a.ordinal()][b.ordinal()] = (byte)(BAM_ORDINAL_TO_ENCODED_BASES[a.ordinal()] << 4 | BAM_ORDINAL_TO_ENCODED_BASES[b.ordinal()]);
            }
        }
    }

    private static final class SamDateFormat
    extends DateFormat {
        private static final long serialVersionUID = 1L;
        private static final String DATE_FULL_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
        private static final String DAY_ONLY_FORMAT = "yyyy-MM-dd";
        private static final String NO_SECONDS_FORMAT = "yyyy-MM-dd'T'HH:mm";
        private static final int DAY_ONLY_LENGTH = 10;
        private static final int NOT_SECONDS_LENGTH = 16;
        final DateFormat full = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        final DateFormat dayOnly = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        final DateFormat noSeconds = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm", Locale.US);

        private SamDateFormat() {
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            return this.full.format(date, toAppendTo, fieldPosition);
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            int inputLength = source.length() - pos.getIndex();
            if (inputLength == 10) {
                return this.dayOnly.parse(source, pos);
            }
            if (inputLength == 16) {
                return this.noSeconds.parse(source, pos);
            }
            return this.full.parse(source, pos);
        }
    }
}

