/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta.qual;

import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.FastaFileParser;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.qual.QualityFastaDataStore;
import org.jcvi.jillion.fasta.qual.QualityFastaRecord;
import org.jcvi.jillion.fasta.qual.QualityFastaRecordBuilder;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.fasta.AbstractLargeFastaFileDataStore;
import org.jcvi.jillion.internal.fasta.AbstractResuseableFastaRecordVisitor;
import org.jcvi.jillion.internal.fasta.qual.QualitySequenceFastaDataStoreIteratorImpl;

public final class LargeQualityFastaFileDataStore
extends AbstractLargeFastaFileDataStore<PhredQuality, QualitySequence, QualityFastaRecord, QualitySequenceDataStore>
implements QualityFastaDataStore {
    public static QualityFastaDataStore create(File fastaFile) throws IOException {
        return LargeQualityFastaFileDataStore.create(fastaFile, (Predicate<String>)DataStoreFilters.alwaysAccept(), null);
    }

    public static QualityFastaDataStore create(File fastaFile, Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter) throws IOException {
        FastaParser parser = FastaFileParser.create(fastaFile);
        return new LargeQualityFastaFileDataStore(parser, filter, recordFilter);
    }

    public static QualityFastaDataStore create(FastaParser parser) {
        return LargeQualityFastaFileDataStore.create(parser, (Predicate<String>)DataStoreFilters.alwaysAccept(), null);
    }

    public static QualityFastaDataStore create(FastaParser parser, Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter) {
        return new LargeQualityFastaFileDataStore(parser, filter, recordFilter);
    }

    protected LargeQualityFastaFileDataStore(FastaParser parser, Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter) {
        super(parser, filter, recordFilter);
    }

    @Override
    protected StreamingIterator<QualityFastaRecord> createNewIterator(FastaParser parser, Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter) {
        StreamingIterator<QualityFastaRecord> iter = QualitySequenceFastaDataStoreIteratorImpl.createIteratorFor(parser, filter, recordFilter);
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    protected FastaRecordVisitor createRecordVisitor(String id, String comment, final Consumer<QualityFastaRecord> callback) {
        return new AbstractResuseableFastaRecordVisitor(){

            @Override
            public void visitRecord(String id, String optionalComment, String fullBody) {
                QualityFastaRecord record = (QualityFastaRecord)((QualityFastaRecordBuilder)new QualityFastaRecordBuilder(id, fullBody).comment(optionalComment)).build();
                callback.accept(record);
            }
        };
    }
}

