/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.internal.fasta.qual;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.FastaFileParser;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.FastaVisitor;
import org.jcvi.jillion.fasta.FastaVisitorCallback;
import org.jcvi.jillion.fasta.qual.AbstractQualityFastaRecordVisitor;
import org.jcvi.jillion.fasta.qual.QualityFastaDataStore;
import org.jcvi.jillion.fasta.qual.QualityFastaRecord;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.fasta.qual.QualitySequenceFastaDataStoreIteratorImpl;

public final class IndexedQualityFastaFileDataStore {
    private IndexedQualityFastaFileDataStore() {
    }

    public static QualityFastaDataStore create(File fastaFile) throws IOException {
        return IndexedQualityFastaFileDataStore.create(fastaFile, (Predicate<String>)DataStoreFilters.alwaysAccept(), null);
    }

    public static QualityFastaDataStore create(File fastaFile, Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter) throws IOException {
        FastaParser parser = FastaFileParser.create(fastaFile);
        return IndexedQualityFastaFileDataStore.create(parser, filter, recordFilter);
    }

    public static QualityFastaDataStore create(FastaParser parser, Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter) throws IOException {
        if (parser == null) {
            throw new NullPointerException("parser can not be null");
        }
        IndexedQualitySequenceFastaDataStoreBuilderVisitor2 builder = new IndexedQualitySequenceFastaDataStoreBuilderVisitor2(parser, filter, recordFilter);
        builder.initialize();
        return builder.build();
    }

    private static class SingleRecordVisitor
    implements FastaVisitor {
        private QualityFastaRecord fastaRecord = null;

        private SingleRecordVisitor() {
        }

        @Override
        public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, String id, String optionalComment) {
            if (this.fastaRecord != null) {
                callback.haltParsing();
                return null;
            }
            return new AbstractQualityFastaRecordVisitor(id, optionalComment){

                @Override
                protected void visitRecord(QualityFastaRecord fastaRecord) {
                    fastaRecord = fastaRecord;
                }
            };
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }
    }

    public static final class Impl
    implements QualityFastaDataStore {
        private volatile boolean closed = false;
        private final FastaParser parser;
        private final Predicate<String> filter;
        private final Predicate<QualityFastaRecord> recordFilter;
        private final Map<String, FastaVisitorCallback.FastaVisitorMemento> mementos;

        public Impl(FastaParser parser, Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter, Map<String, FastaVisitorCallback.FastaVisitorMemento> mementos) {
            this.parser = parser;
            this.mementos = mementos;
            this.filter = filter;
            this.recordFilter = recordFilter;
        }

        @Override
        public StreamingIterator<String> idIterator() throws DataStoreException {
            this.throwExceptionIfClosed();
            return DataStoreStreamingIterator.create(this, this.mementos.keySet().iterator());
        }

        @Override
        public QualityFastaRecord get(String id) throws DataStoreException {
            this.throwExceptionIfClosed();
            if (!this.mementos.containsKey(id)) {
                return null;
            }
            SingleRecordVisitor visitor = new SingleRecordVisitor();
            try {
                this.parser.parse(visitor, this.mementos.get(id));
                return visitor.fastaRecord;
            }
            catch (IOException e) {
                throw new DataStoreException("error reading fasta file", e);
            }
        }

        @Override
        public StreamingIterator<QualityFastaRecord> iterator() throws DataStoreException {
            this.throwExceptionIfClosed();
            StreamingIterator<QualityFastaRecord> iter = QualitySequenceFastaDataStoreIteratorImpl.createIteratorFor(this.parser, this.filter, this.recordFilter);
            return DataStoreStreamingIterator.create(this, iter);
        }

        @Override
        public StreamingIterator<DataStoreEntry<QualityFastaRecord>> entryIterator() throws DataStoreException {
            this.throwExceptionIfClosed();
            StreamingIterator<DataStoreEntry<QualityFastaRecord>> entryIter = new StreamingIterator<DataStoreEntry<QualityFastaRecord>>(){
                StreamingIterator<QualityFastaRecord> iter;
                {
                    this.iter = QualitySequenceFastaDataStoreIteratorImpl.createIteratorFor(parser, filter, recordFilter);
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public void close() {
                    this.iter.close();
                }

                @Override
                public DataStoreEntry<QualityFastaRecord> next() {
                    QualityFastaRecord next = this.iter.next();
                    return new DataStoreEntry<QualityFastaRecord>(next.getId(), next);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return DataStoreStreamingIterator.create(this, entryIter);
        }

        private void throwExceptionIfClosed() throws DataStoreException {
            if (this.closed) {
                throw new DataStoreClosedException("datastore is closed");
            }
        }

        @Override
        public boolean contains(String id) throws DataStoreException {
            this.throwExceptionIfClosed();
            return this.mementos.containsKey(id);
        }

        @Override
        public long getNumberOfRecords() throws DataStoreException {
            this.throwExceptionIfClosed();
            return this.mementos.size();
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    private static final class IndexedQualitySequenceFastaDataStoreBuilderVisitor2
    implements FastaVisitor,
    Builder<QualityFastaDataStore> {
        private final Predicate<String> filter;
        private final Predicate<QualityFastaRecord> recordFilter;
        private final FastaParser parser;
        private final Map<String, FastaVisitorCallback.FastaVisitorMemento> mementos = new LinkedHashMap<String, FastaVisitorCallback.FastaVisitorMemento>();

        private IndexedQualitySequenceFastaDataStoreBuilderVisitor2(FastaParser parser, Predicate<String> filter, Predicate<QualityFastaRecord> recordFilter) throws IOException {
            this.filter = filter;
            this.parser = parser;
            this.recordFilter = recordFilter;
        }

        public void initialize() throws IOException {
            this.parser.parse(this);
        }

        @Override
        public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, final String id, String optionalComment) {
            if (this.filter.test(id)) {
                if (!callback.canCreateMemento()) {
                    throw new IllegalStateException("must be able to create memento");
                }
                final FastaVisitorCallback.FastaVisitorMemento memento = callback.createMemento();
                if (this.recordFilter == null) {
                    this.mementos.put(id, memento);
                } else {
                    return new AbstractQualityFastaRecordVisitor(id, optionalComment){

                        @Override
                        protected void visitRecord(QualityFastaRecord fastaRecord) {
                            if (recordFilter.test(fastaRecord)) {
                                mementos.put(id, memento);
                            }
                        }
                    };
                }
            }
            return null;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        @Override
        public QualityFastaDataStore build() {
            return new Impl(this.parser, this.filter, this.recordFilter, this.mementos);
        }
    }
}

